/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.target.HuntMobTarget;

public class ProtectChildrenTarget<T extends LivingEntity>
extends HuntMobTarget<T> {
    private Mob protectTarget;

    public ProtectChildrenTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super(creature, classTarget, checkSight, 200, false, targetSelector);
    }

    @Override
    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        Mob mob;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || !((Boolean)ConfigGamerules.attackUndead.get()).booleanValue() && entity.m_6336_() == MobType.f_21641_ || predicate != null && !predicate.test(entity)) {
            return false;
        }
        if (ComplexMob.getEcoLevel(entity) < ComplexMob.getEcoLevel((LivingEntity)this.f_26135_) && this.f_26135_.getClass() == entity.getClass() && (mob = this.f_26135_) instanceof ComplexMob) {
            ComplexMob attacker = (ComplexMob)mob;
            if (entity instanceof ComplexMob) {
                ComplexMob defender = (ComplexMob)entity;
                if (attacker.getVariant() == defender.getVariant()) {
                    return false;
                }
            }
        }
        return this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    @Override
    public boolean m_8036_() {
        TamableAnimal tamable;
        Object object;
        if (this.f_26135_.m_6162_() || (object = this.f_26135_) instanceof TamableAnimal && (tamable = (TamableAnimal)object).m_21824_()) {
            return false;
        }
        object = this.f_26135_;
        if (object instanceof ComplexMob) {
            ComplexMob temp = (ComplexMob)((Object)object);
            for (Mob child : this.f_26135_.f_19853_.m_45976_(this.f_26135_.getClass(), this.f_26135_.m_20191_().m_82377_(8.0, 4.0, 8.0))) {
                if (!child.m_6162_() || ((ComplexMob)child).getVariant() != temp.getVariant()) continue;
                this.protectTarget = child;
                List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.getTargettableArea(this.m_7623_()), this.targetEntitySelector);
                if (list.isEmpty()) {
                    return false;
                }
                list.sort(this.sorter);
                this.f_26137_ = (LivingEntity)list.get(0);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean m_8045_() {
        if (this.protectTarget.m_20270_((Entity)this.f_26135_) > 12.0f) {
            this.f_26135_.m_6710_(null);
            this.f_26137_ = null;
            this.f_26135_.m_21573_().m_5624_((Entity)this.protectTarget, 1.0);
            return false;
        }
        return super.m_8045_();
    }

    protected double m_7623_() {
        return super.m_7623_() * 0.5;
    }
}

