/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.AABB;
import untamedwilds.entity.ComplexMob;

public class GuardPositionTarget<T extends LivingEntity>
extends TargetGoal {
    protected BlockPos guardPos;
    protected final Class<T> targetClass;
    protected final Sorter sorter;
    protected Predicate<? super T> targetEntitySelector;

    public GuardPositionTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean isCannibal, Predicate<LivingEntity> targetSelector) {
        super((Mob)creature, checkSight, true);
        this.targetClass = classTarget;
        this.sorter = new Sorter((Entity)creature);
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE, Goal.Flag.JUMP));
        this.targetEntitySelector = entity -> this.isValidTarget((LivingEntity)entity, targetSelector);
    }

    protected boolean isValidTarget(LivingEntity entity, @Nullable Predicate<LivingEntity> predicate) {
        TamableAnimal tamable;
        if (entity instanceof Creeper || entity.equals((Object)this.f_26135_) || predicate != null && !predicate.test(entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            return false;
        }
        return this.m_26150_(entity, TargetingConditions.m_148352_().m_26883_(this.m_7623_()));
    }

    public boolean m_8036_() {
        List list;
        ComplexMob cmob;
        if (this.f_26135_.m_6162_() || this.f_26135_.m_21223_() < this.f_26135_.m_21233_() / 3.0f) {
            return false;
        }
        Mob mob = this.f_26135_;
        if (mob instanceof ComplexMob && (!(cmob = (ComplexMob)mob).m_21824_() || cmob.getCommandInt() != 3)) {
            return false;
        }
        if (this.guardPos == null) {
            this.guardPos = this.f_26135_.m_20183_();
        }
        if ((list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.getTargettableArea(this.m_7623_()), this.targetEntitySelector)).isEmpty() && this.guardPos != null) {
            this.f_26135_.m_21573_().m_26519_((double)this.guardPos.m_123341_(), (double)this.guardPos.m_123342_(), (double)this.guardPos.m_123343_(), 1.0);
            if (this.f_26135_.m_20275_((double)this.guardPos.m_123341_(), (double)this.guardPos.m_123342_(), (double)this.guardPos.m_123343_()) < 2.0) {
                this.f_26135_.m_21573_().m_26573_();
                Mob mob2 = this.f_26135_;
                if (mob2 instanceof ComplexMob) {
                    ComplexMob cmob2 = (ComplexMob)mob2;
                    cmob2.setSitting(true);
                }
            }
            return false;
        }
        list.sort(this.sorter);
        this.f_26137_ = (LivingEntity)list.get(0);
        return true;
    }

    AABB getTargettableArea(double targetDistance) {
        return this.f_26135_.m_20191_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        if (!this.f_26135_.m_21573_().m_26571_()) {
            this.f_26135_.m_21573_().m_26573_();
        }
        if (this.f_26135_ instanceof ComplexMob) {
            ((ComplexMob)this.f_26135_).huntingCooldown = 6000;
        }
        this.f_26135_.m_6710_(this.f_26137_);
        super.m_8056_();
    }

    public boolean m_8045_() {
        return super.m_8045_();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        private Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity entity_1, Entity entity_2) {
            double dist_2;
            double dist_1 = this.entity.m_20280_(entity_1);
            if (dist_1 < (dist_2 = this.entity.m_20280_(entity_2))) {
                return -1;
            }
            return dist_1 > dist_2 ? 1 : 0;
        }
    }
}

