/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import untamedwilds.entity.ComplexMob;

public class SmartFollowOwnerGoal
extends Goal {
    protected final ComplexMob taskOwner;
    private LivingEntity owner;
    protected final Level level;
    private final double followSpeed;
    private final PathNavigation navigator;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;

    public SmartFollowOwnerGoal(ComplexMob entityIn, double speedIn, float minDistIn, float maxDistIn) {
        this.taskOwner = entityIn;
        this.level = this.taskOwner.f_19853_;
        this.followSpeed = speedIn;
        this.navigator = entityIn.m_21573_();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(entityIn.m_21573_() instanceof GroundPathNavigation) && !(entityIn.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for SmartFollowOwnerGoal");
        }
    }

    public boolean m_8036_() {
        LivingEntity owner = this.taskOwner.m_21826_();
        if (owner == null || owner.m_5833_() || !this.taskOwner.canMove() || this.taskOwner.m_20280_((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return this.taskOwner.getCommandInt() == 1;
    }

    public boolean m_8045_() {
        return !this.navigator.m_26571_() && this.taskOwner.m_20280_((Entity)this.owner) > (double)(this.maxDist * this.maxDist) && !this.taskOwner.isSitting();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.taskOwner.m_21439_(BlockPathTypes.WATER);
        this.taskOwner.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.navigator.m_26573_();
        this.taskOwner.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.taskOwner.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.taskOwner.m_21529_());
        if (this.taskOwner.canMove() && this.taskOwner.getCommandInt() == 1 && --this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.taskOwner.m_21523_() && !this.taskOwner.m_20159_() && !this.navigator.m_5624_((Entity)this.owner, this.followSpeed) && this.taskOwner.m_20280_((Entity)this.owner) >= 225.0 && this.taskOwner.m_5448_() == null) {
                this.teleportToOwner();
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
        if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
            return false;
        }
        this.taskOwner.m_7678_((double)p_25304_ + 0.5, p_25305_, (double)p_25306_ + 0.5, this.taskOwner.m_146908_(), this.taskOwner.m_146909_());
        this.taskOwner.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos p_25308_) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
        if (blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.taskOwner.m_20183_());
        return this.level.m_45756_((Entity)this.taskOwner, this.taskOwner.m_20191_().m_82377_(1.0, 0.0, 1.0).m_82338_(blockpos));
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.taskOwner.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
    }
}

