/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.init.ModTags;

public class ActiveGrazeGoal
extends MoveToBlockGoal {
    private final ComplexMobTerrestrial taskOwner;
    public final Level entityWorld;
    public BlockPos eatPos;
    private int eatingGrassTimer = -1;
    private final int executionChance;

    public ActiveGrazeGoal(ComplexMobTerrestrial entityIn, int chance) {
        super((PathfinderMob)entityIn, 1.0, chance);
        this.taskOwner = entityIn;
        this.entityWorld = entityIn.f_19853_;
        this.executionChance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.taskOwner.canMove() || this.taskOwner.m_6162_() || this.taskOwner.getHunger() > 100 || this.taskOwner.m_5448_() != null || this.taskOwner.m_217043_().m_188503_(this.executionChance) != 0) {
            return false;
        }
        this.eatPos = this.getEatPos();
        if (this.taskOwner.getHunger() < 40) {
            this.eatingGrassTimer = -1;
            return this.locateGrazeables();
        }
        return this.tryStartEating();
    }

    public void m_8056_() {
        super.m_8056_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.eatingGrassTimer = 0;
    }

    public boolean m_8045_() {
        return !super.m_25625_() && this.eatingGrassTimer != 0;
    }

    public void m_8037_() {
        super.m_8037_();
        this.tryStartEating();
        if (this.eatingGrassTimer > 0) {
            this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
            if (this.eatingGrassTimer == 4) {
                if (this.entityWorld.m_8055_(this.eatPos).m_204336_(ModTags.ModBlockTags.GRAZEABLE_BLOCKS)) {
                    if (ForgeEventFactory.getMobGriefingEvent((Level)this.entityWorld, (Entity)this.taskOwner) && ((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                        this.entityWorld.m_46961_(this.eatPos, false);
                    }
                    this.taskOwner.addHunger(16);
                    this.taskOwner.m_8035_();
                } else {
                    BlockPos blockpos1 = this.eatPos.m_7495_();
                    if (this.entityWorld.m_8055_(blockpos1).m_60734_() == Blocks.f_50440_ && ForgeEventFactory.getMobGriefingEvent((Level)this.entityWorld, (Entity)this.taskOwner)) {
                        this.entityWorld.m_6798_(2001, blockpos1, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                        if (((Boolean)ConfigGamerules.grazerGriefing.get()).booleanValue()) {
                            this.entityWorld.m_7731_(blockpos1, Blocks.f_50493_.m_49966_(), 2);
                        }
                        this.taskOwner.addHunger(16);
                        this.taskOwner.m_8035_();
                    }
                }
            }
        }
    }

    protected boolean m_6465_(LevelReader worldIn, BlockPos posIn) {
        if (this.entityWorld.m_8055_(posIn).m_204336_(ModTags.ModBlockTags.GRAZEABLE_BLOCKS) || this.entityWorld.m_8055_(posIn.m_7495_()).m_60734_() == Blocks.f_50440_ && this.taskOwner.m_217043_().m_188503_(2) == 0) {
            Path path = this.f_25598_.m_21573_().m_7864_(posIn, 1);
            return path != null && path.m_77403_();
        }
        return false;
    }

    private boolean locateGrazeables() {
        int i = 8;
        int j = 3;
        BlockPos blockpos = this.f_25598_.m_20183_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int k = this.f_25603_;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutableblockpos.m_122154_((Vec3i)blockpos, i1, k - 1, j1);
                        if (this.f_25598_.m_21444_((BlockPos)blockpos$mutableblockpos) && this.m_6465_((LevelReader)this.f_25598_.f_19853_, (BlockPos)blockpos$mutableblockpos)) {
                            this.f_25602_ = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    public boolean tryStartEating() {
        if (this.isGrazeable() && this.eatingGrassTimer == -1) {
            this.eatPos = this.getEatPos();
            this.eatingGrassTimer = 40;
            this.entityWorld.m_7605_((Entity)this.taskOwner, (byte)10);
            this.taskOwner.m_21573_().m_26573_();
            this.taskOwner.setAnimation(this.taskOwner.getAnimationEat());
            return true;
        }
        return false;
    }

    public boolean isGrazeable() {
        return this.entityWorld.m_8055_(this.getEatPos()).m_204336_(ModTags.ModBlockTags.GRAZEABLE_BLOCKS) || this.entityWorld.m_8055_(this.getEatPos().m_7495_()).m_60734_() == Blocks.f_50440_;
    }

    public BlockPos getEatPos() {
        return this.taskOwner.m_20183_().m_7637_(Math.cos(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2, 0.0, Math.sin(Math.toRadians(this.taskOwner.m_146908_() + 90.0f)) * 1.2);
    }

    public double m_8052_() {
        return 1.8;
    }
}

