/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class ReptileNestBlockEntity
extends BlockEntity {
    private EntityType<?> entityType = (EntityType)ModEntity.SOFTSHELL_TURTLE.get();
    private int variant = 1;
    private int eggCount = 4;

    public ReptileNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlock.TILE_ENTITY_NEST_REPTILE.get(), pos, state);
    }

    public int getSumMobs() {
        return this.eggCount;
    }

    public boolean hasNoMobs() {
        return this.getSumMobs() == 0;
    }

    public void createMobs(ServerLevel worldIn) {
        BlockPos blockpos;
        if (!this.hasNoMobs() && this.getEntityType() != null && (double)worldIn.m_213780_().m_188501_() < 0.05 && worldIn.m_45914_((double)(blockpos = this.m_58899_()).m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, (double)((Integer)ConfigMobControl.critterSpawnRange.get()).intValue())) {
            int spawnCount = worldIn.m_213780_().m_188503_(3) + 1;
            for (int i = 0; i < spawnCount; ++i) {
                Entity spawn;
                RandomSource rand = worldIn.m_213780_();
                float offsetX = rand.m_188501_();
                float offsetZ = rand.m_188501_();
                if (this.getEggCount() <= 0 || this.getEntityType() == null || !worldIn.m_45772_(this.getEntityType().m_20585_((double)((float)blockpos.m_123341_() + offsetX), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + offsetZ)).m_82406_((double)(this.getEntityType().m_20678_() / 4.0f)).m_82386_(0.0, 4.0, 0.0)) || (spawn = this.getEntityType().m_20615_((Level)worldIn)) == null) continue;
                spawn.m_7678_((double)((float)blockpos.m_123341_() + offsetX), (double)blockpos.m_123342_(), (double)((float)blockpos.m_123343_() + offsetZ), Mth.m_14177_((float)(rand.m_188501_() * 360.0f)), 0.0f);
                if (spawn instanceof Mob) {
                    Mob mobSpawn = (Mob)spawn;
                    mobSpawn.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(blockpos), MobSpawnType.BREEDING, null, null);
                }
                if (spawn instanceof ComplexMob) {
                    ComplexMob entitySpawn = (ComplexMob)spawn;
                    entitySpawn.setVariant(EntityUtils.getClampedNumberOfSpecies(this.variant, this.entityType));
                    entitySpawn.m_146762_(ComplexMob.getEntityData(this.entityType).getGrowingTime(this.variant) * (Integer)ConfigGamerules.cycleLength.get() * -2);
                    entitySpawn.m_6863_(true);
                    entitySpawn.setGender(worldIn.m_213780_().m_188503_(2));
                    entitySpawn.setRandomMobSize();
                    entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                    if (entitySpawn instanceof INeedsPostUpdate) {
                        ((INeedsPostUpdate)((Object)entitySpawn)).updateAttributes();
                    }
                }
                worldIn.m_47205_(spawn);
                worldIn.m_5594_(null, this.m_58899_(), SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.m_213780_().m_188501_() * 0.2f);
                this.spawnParticles((Level)worldIn, spawn.m_20185_(), spawn.m_20186_(), spawn.m_20189_(), new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50578_.m_49966_()));
                this.removeEggs((Level)worldIn, 1);
                this.m_6596_();
            }
        }
    }

    public void trampleOnNest(Level worldIn, BlockPos posIn, BlockState stateIn) {
        worldIn.m_5594_(null, posIn, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + worldIn.f_46441_.m_188501_() * 0.2f);
        this.removeEggs(worldIn, Math.min(worldIn.m_213780_().m_188503_(2), this.getEggCount() / 2) + 1);
        worldIn.m_46796_(2001, posIn, Block.m_49956_((BlockState)stateIn));
    }

    public void removeEggs(Level worldIn, int count) {
        this.setEggCount(this.eggCount - count);
        if (this.eggCount <= 0) {
            worldIn.m_46961_(this.m_58899_(), false);
        }
    }

    public void setEggCount(int newCount) {
        this.eggCount = newCount;
    }

    public int getEggCount() {
        return this.eggCount;
    }

    public void setVariant(int variant) {
        this.variant = variant;
    }

    public int getVariant() {
        return this.variant;
    }

    public void setEntityType(EntityType<?> type) {
        this.entityType = type;
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    private <T extends ParticleOptions> void spawnParticles(Level worldIn, double x, double y, double z, T particle) {
        RandomSource random = worldIn.m_213780_();
        float d3 = random.m_188501_() * 0.02f;
        float d1 = random.m_188501_() * 0.02f;
        float d2 = random.m_188501_() * 0.02f;
        ((ServerLevel)worldIn).m_8767_(particle, x, y, z, 15, (double)d3, (double)d1, (double)d2, (double)0.12f);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.setVariant(compound.m_128451_("Variant"));
        this.setEggCount(compound.m_128451_("Count"));
        if (compound.m_128441_("EntityType")) {
            this.setEntityType(EntityType.m_20632_((String)compound.m_128461_("EntityType")).orElse(null));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("Count", this.getEggCount());
        compound.m_128405_("Variant", this.getVariant());
        if (this.getEntityType() != null && this.getEntityType().m_204041_().m_205785_().m_135782_() != null) {
            compound.m_128359_("EntityType", this.getEntityType().m_204041_().m_205785_().m_135782_().toString());
        }
    }
}

