/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import untamedwilds.block.IPostGenUpdate;
import untamedwilds.init.ModBlock;
import untamedwilds.init.ModItems;
import untamedwilds.init.ModTags;

public class TitanArumBlock
extends Block
implements BonemealableBlock,
IPostGenUpdate {
    protected static final VoxelShape SHAPE_NORMAL = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE_SPATHE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SHAPE_CORM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    public static final IntegerProperty PROPERTY_AGE = BlockStateProperties.f_61408_;
    public static final IntegerProperty PROPERTY_STAGE = BlockStateProperties.f_61387_;

    public TitanArumBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PROPERTY_AGE, PROPERTY_STAGE});
    }

    public ItemStack getCloneItemStack(BlockState stateIn, HitResult hitResultIn, BlockGetter blockGetterIn, BlockPos posIn, Player playerIn) {
        return new ItemStack((ItemLike)ModItems.SEED_TITAN_ARUM.get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if ((Integer)state.m_61143_((Property)PROPERTY_AGE) == 0) {
            return SHAPE_CORM;
        }
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        VoxelShape shape = (Integer)state.m_61143_((Property)PROPERTY_AGE) == 1 && (Integer)state.m_61143_((Property)PROPERTY_STAGE) == 1 ? SHAPE_NORMAL : SHAPE_SPATHE;
        return shape.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        int i;
        if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 0 && random.m_188503_(8) == 0 && worldIn.m_46859_(pos.m_7494_()) && worldIn.m_7146_(pos.m_7494_()) >= 9 && (i = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos) + 1) < 4 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_(3) == 0 ? 1 : 0) != 0)) {
            this.grow(state, (Level)worldIn, pos, random, i);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
        if ((Integer)state.m_61143_((Property)PROPERTY_STAGE) == 1 && (Integer)state.m_61143_((Property)PROPERTY_AGE) > 1) {
            this.spawnParticles((Level)worldIn, pos, ParticleTypes.f_123779_);
            List list = worldIn.m_45976_(Mob.class, new AABB((double)(pos.m_123341_() - 16), (double)(pos.m_123342_() - 4), (double)(pos.m_123343_() - 16), (double)(pos.m_123341_() + 16), (double)(pos.m_123342_() + 4), (double)(pos.m_123343_() + 16)));
            for (Mob mob : list) {
                if (mob.m_5448_() != null || mob.m_6336_() != MobType.f_21642_ && mob.m_6336_() != MobType.f_21641_) continue;
                mob.m_21573_().m_26519_((double)(pos.m_123341_() + random.m_188503_(6) - 3), (double)pos.m_123342_(), (double)(pos.m_123343_() + random.m_188503_(6) - 3), 1.0);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if (blockstate.m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON)) {
            return (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(0));
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.m_8055_(pos.m_7495_()).m_204336_(ModTags.ModBlockTags.REEDS_PLANTABLE_ON) || worldIn.m_8055_(pos.m_7495_()).m_60734_() == ModBlock.TITAN_ARUM.get();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void grow(BlockState blockStateIn, Level worldIn, BlockPos posIn, RandomSource rand, int p_220258_5_) {
        int l = (Integer)blockStateIn.m_61143_((Property)PROPERTY_AGE);
        if (l == 0) {
            worldIn.m_46597_(posIn, (BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(1)));
        } else {
            worldIn.m_7731_(posIn.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(Math.min(3, l + 1)))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        return player.m_21205_().canPerformAction(ToolActions.SWORD_DIG) ? 1.0f : super.m_5880_(state, player, worldIn, pos);
    }

    protected int getNumReedBlocksAbove(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; worldIn.m_8055_(pos.m_6630_(i + 1)).m_60734_() == ModBlock.TITAN_ARUM.get() || i > 20; ++i) {
        }
        return i;
    }

    protected int getNumReedBlocksBelow(BlockGetter worldIn, BlockPos pos) {
        int i;
        for (i = 0; worldIn.m_8055_(pos.m_6625_(i + 1)).m_60734_() == ModBlock.TITAN_ARUM.get() || i > 20; ++i) {
        }
        return i;
    }

    private void makeAreaOfEffectCloud(Level worldIn, BlockPos pos) {
        AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(worldIn, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() - (Integer)worldIn.m_8055_(pos).m_61143_((Property)PROPERTY_AGE)), (double)pos.m_123343_() + 0.5);
        areaeffectcloudentity.m_19712_(6.0f);
        areaeffectcloudentity.m_19732_(-0.2f);
        areaeffectcloudentity.m_19740_(10);
        areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / ((float)areaeffectcloudentity.m_19748_() * 0.5f));
        areaeffectcloudentity.m_19714_(5599028);
        areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19604_, 80, 0, true, false));
        worldIn.m_7967_((Entity)areaeffectcloudentity);
    }

    @Override
    public void updatePostGen(LevelAccessor worldIn, BlockPos pos) {
        for (int i = 0; i < 3 && (worldIn.m_8055_(pos.m_6630_(i)).m_60795_() || worldIn.m_8055_(pos.m_6630_(i)).m_60734_() == ModBlock.TITAN_ARUM.get()); ++i) {
            worldIn.m_7731_(pos.m_6630_(i), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)Integer.valueOf(i + 1))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 3);
        }
    }

    private <T extends ParticleOptions> void spawnParticles(Level worldIn, BlockPos pos, T particle) {
        RandomSource random = worldIn.m_213780_();
        for (int i = 0; i < 6; ++i) {
            float d3 = random.m_188501_() * 0.02f;
            float d1 = random.m_188501_() * 0.02f;
            float d2 = random.m_188501_() * 0.02f;
            ((ServerLevel)worldIn).m_8767_(particle, (double)pos.m_123341_() + 0.275 + (double)random.m_188501_() * 0.45, (double)((float)pos.m_123342_() + random.m_188501_()), (double)pos.m_123343_() + 0.275 + (double)random.m_188501_() * 0.45, 1, (double)d3, (double)d1, (double)d2, (double)0.02f);
        }
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        int j;
        int i = this.getNumReedBlocksAbove(worldIn, pos);
        return i + (j = this.getNumReedBlocksBelow(worldIn, pos)) + 1 < 4 && (Integer)worldIn.m_8055_(pos.m_6630_(i)).m_61143_((Property)PROPERTY_STAGE) != 1;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = this.getNumReedBlocksAbove((BlockGetter)worldIn, pos);
        int j = this.getNumReedBlocksBelow((BlockGetter)worldIn, pos);
        int k = i + j + 1;
        if (j < 3) {
            BlockPos blockpos = pos.m_6630_(i);
            BlockState blockstate = worldIn.m_8055_(blockpos);
            if (worldIn.m_8055_(pos.m_7495_()).m_60734_() == ModBlock.TITAN_ARUM.get() || (Integer)blockstate.m_61143_((Property)PROPERTY_STAGE) == 1 || !worldIn.m_46859_(blockpos.m_7494_())) {
                return;
            }
            if (k >= 3) {
                this.makeAreaOfEffectCloud((Level)worldIn, pos);
                for (i = 0; i < 3 && worldIn.m_8055_(pos.m_6630_(i)).m_60734_() == ModBlock.TITAN_ARUM.get(); ++i) {
                    worldIn.m_7731_(pos.m_6630_(i), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PROPERTY_AGE, (Comparable)((Integer)worldIn.m_8055_(pos.m_6630_(i)).m_61143_((Property)PROPERTY_AGE)))).m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 3);
                }
                for (int l = 0; l < 2; ++l) {
                    BlockPos seed_pos = pos.m_7918_(rand.m_188503_(3) - 1, 1 - rand.m_188503_(3), rand.m_188503_(3) - 1);
                    if (!worldIn.m_46739_(seed_pos) || worldIn.m_8055_(seed_pos).m_60713_(Blocks.f_49990_) || !blockstate.m_60710_((LevelReader)worldIn, seed_pos)) continue;
                    worldIn.m_7731_(seed_pos, (BlockState)((Block)ModBlock.TITAN_ARUM.get()).m_49966_().m_61124_((Property)PROPERTY_STAGE, (Comparable)Integer.valueOf(1)), 2);
                }
                return;
            }
            this.grow(blockstate, (Level)worldIn, blockpos, rand, k);
        }
    }
}

