/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.recipe;

import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.item.OilCanItem;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class OilCanRecipe
extends ShapelessRecipe {
    final int fuelAmount;

    public OilCanRecipe(ResourceLocation id, String group, ItemStack result, NonNullList<Ingredient> recipeItems, int fuelAmount) {
        super(id, group, result, recipeItems);
        this.fuelAmount = fuelAmount;
    }

    public ItemStack m_5874_(CraftingContainer grid) {
        for (int i = 0; i < grid.m_6643_(); ++i) {
            ItemStack itemstack = grid.m_8020_(i);
            if (!(itemstack.m_41720_() instanceof OilCanItem)) continue;
            OilCanItem can = (OilCanItem)itemstack.m_41720_();
            int startFuel = OilCanItem.getFuel(itemstack);
            return OilCanItem.setFuel(itemstack.m_41777_(), (int)((double)startFuel + (double)this.fuelAmount * (Double)Config.oilRecipeMultiplier.get()));
        }
        return ItemStack.f_41583_;
    }

    public static class Serializer
    implements RecipeSerializer<OilCanRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("hardcore_torches", "oil_can");

        public OilCanRecipe fromJson(ResourceLocation resourceLocation, JsonObject json) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(resourceLocation, json);
            int fuel = json.get("fuel").getAsInt();
            return new OilCanRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), (NonNullList<Ingredient>)recipe.m_7527_(), fuel);
        }

        public OilCanRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            ShapelessRecipe recipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_8005_(resourceLocation, friendlyByteBuf);
            int fuelValue = friendlyByteBuf.m_130242_();
            return new OilCanRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_8043_(), (NonNullList<Ingredient>)recipe.m_7527_(), fuelValue);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, OilCanRecipe oilCanRecipe) {
            ShapelessRecipe rec = new ShapelessRecipe(oilCanRecipe.m_6423_(), oilCanRecipe.m_6076_(), oilCanRecipe.m_8043_(), oilCanRecipe.m_7527_());
            ShapelessRecipe.Serializer.f_44077_.m_6178_(friendlyByteBuf, (Recipe)rec);
            friendlyByteBuf.m_130130_(oilCanRecipe.fuelAmount);
        }
    }
}

