/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.MainMod;
import com.github.wolfiewaffle.hardcore_torches.block.AbstractHardcoreTorchBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import com.github.wolfiewaffle.hardcore_torches.util.ETorchState;
import com.github.wolfiewaffle.hardcore_torches.util.TorchGroup;
import java.awt.Color;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class TorchItem
extends StandingAndWallBlockItem {
    public ETorchState burnState;
    TorchGroup torchGroup;
    public IntSupplier maxFuel;

    public TorchItem(Block floorBlock, Block wallBlock, Item.Properties properties) {
        super(floorBlock, wallBlock, properties);
        this.burnState = ((AbstractHardcoreTorchBlock)floorBlock).burnState;
        this.torchGroup = ((AbstractHardcoreTorchBlock)floorBlock).group;
        this.maxFuel = ((AbstractHardcoreTorchBlock)floorBlock).maxFuel;
    }

    public int getMaxFuel() {
        return this.maxFuel.getAsInt();
    }

    public boolean m_142522_(ItemStack stack) {
        int fuel = TorchItem.getFuel(stack);
        return fuel > 0 && fuel < this.getMaxFuel();
    }

    public int m_142158_(ItemStack stack) {
        int fuel = TorchItem.getFuel(stack);
        int max = this.getMaxFuel();
        if (max != 0) {
            return Math.round(13.0f - (float)(max - fuel) * 13.0f / (float)max);
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        return Color.HSBtoRGB(0.5f, 1.0f, 1.0f);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack cStack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (cStack.m_41720_() instanceof TorchItem) {
            ETorchState torchState = ((TorchItem)cStack.m_41720_()).burnState;
            BlockState blockState = world.m_8055_(pos);
            Block block = blockState.m_60734_();
            if ((torchState == ETorchState.UNLIT || torchState == ETorchState.SMOLDERING) && blockState.m_204336_(MainMod.FREE_TORCH_LIGHT_BLOCKS)) {
                if (blockState.m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                    return super.m_6225_(context);
                }
                Player player = context.m_43723_();
                if (player != null && !world.f_46443_) {
                    player.m_21008_(context.m_43724_(), TorchItem.stateStack(cStack, ETorchState.LIT));
                }
                if (!world.f_46443_) {
                    world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 0.5f, 1.2f);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6225_(context);
    }

    public static ItemStack stateStack(ItemStack inputStack, ETorchState newState) {
        ItemStack outputStack = ItemStack.f_41583_;
        if (inputStack.m_41720_() instanceof BlockItem && inputStack.m_41720_() instanceof TorchItem) {
            AbstractHardcoreTorchBlock newBlock = (AbstractHardcoreTorchBlock)((BlockItem)inputStack.m_41720_()).m_40614_();
            TorchItem newItem = (TorchItem)newBlock.group.getStandingTorch(newState).m_5456_();
            outputStack = TorchItem.changedCopy(inputStack, (Item)newItem);
            if (newState == ETorchState.BURNT) {
                outputStack.m_41751_(null);
            }
        }
        return outputStack;
    }

    public static ItemStack changedCopy(ItemStack stack, Item replacementItem) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)replacementItem, stack.m_41613_());
        if (stack.m_41783_() != null) {
            itemStack.m_41751_(stack.m_41783_().m_6426_());
        }
        return itemStack;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        CompoundTag oldNbt = null;
        CompoundTag newNbt = null;
        if (oldStack.m_41783_() != null) {
            oldNbt = oldStack.m_41783_().m_6426_();
            oldNbt.m_128473_("Fuel");
        }
        if (newStack.m_41783_() != null) {
            newNbt = newStack.m_41783_().m_6426_();
            newNbt.m_128473_("Fuel");
        }
        if (oldNbt == null && newNbt != null) {
            return true;
        }
        if (oldNbt != null && newNbt == null) {
            return true;
        }
        if (oldNbt == null && newNbt == null) {
            return false;
        }
        return oldNbt.equals(null);
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof TorchItem)) {
            return 0;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Fuel")) {
            return nbt.m_128451_("Fuel");
        }
        return ((TorchItem)item).getMaxFuel();
    }

    public boolean sameTorchGroup(TorchItem item1, TorchItem item2) {
        return item1.torchGroup == item2.torchGroup;
    }

    public static ItemStack addFuel(ItemStack stack, Level world, int amount) {
        Item item = stack.m_41720_();
        int maxFuel = item instanceof TorchItem ? ((TorchItem)item).getMaxFuel() : 0;
        if (stack.m_41720_() instanceof TorchItem && !world.f_46443_) {
            CompoundTag nbt = stack.m_41783_();
            int fuel = maxFuel;
            if (nbt != null) {
                fuel = nbt.m_128451_("Fuel");
            } else {
                nbt = new CompoundTag();
            }
            if ((fuel += amount) <= 0) {
                stack = ((Boolean)Config.burntStick.get()).booleanValue() ? new ItemStack((ItemLike)Items.f_42398_, stack.m_41613_()) : TorchItem.stateStack(stack, ETorchState.BURNT);
            } else {
                if (fuel > maxFuel) {
                    fuel = maxFuel;
                }
                nbt.m_128405_("Fuel", fuel);
                stack.m_41751_(nbt);
            }
        }
        return stack;
    }

    public boolean m_142305_(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!slot.m_150651_(player) || !(otherStack.m_41720_() instanceof TorchItem) || otherStack.m_41619_()) {
            return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (!this.sameTorchGroup((TorchItem)slotStack.m_41720_(), (TorchItem)otherStack.m_41720_())) {
            return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (slotStack.m_41613_() < slotStack.m_41741_()) {
            return this.addToLitStack(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }

    public boolean lightCursorStack(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!(otherStack.m_41720_() instanceof TorchItem)) {
            return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        Item newItem = ((TorchItem)otherStack.m_41720_()).torchGroup.getStandingTorch(ETorchState.LIT).m_5456_();
        ItemStack newStack = TorchItem.changedCopy(otherStack, newItem);
        slotAccess.m_142104_(new ItemStack((ItemLike)Items.f_41905_));
        return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }

    public boolean addToLitStack(ItemStack slotStack, ItemStack otherStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        TorchItem slotTorch = (TorchItem)slotStack.m_41720_();
        TorchItem cursorTorch = (TorchItem)otherStack.m_41720_();
        if (slotTorch.burnState == ETorchState.BURNT || cursorTorch.burnState == ETorchState.BURNT) {
            return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        if (slotTorch.burnState == ETorchState.UNLIT) {
            return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
        }
        int max = slotStack.m_41741_();
        int usedCount = clickAction == ClickAction.PRIMARY ? otherStack.m_41613_() : 1;
        int remainder = Math.max(0, usedCount - (max - slotStack.m_41613_()));
        int addedNew = usedCount - remainder;
        int stack1Fuel = TorchItem.getFuel(slotStack) * slotStack.m_41613_();
        int stack2Fuel = TorchItem.getFuel(otherStack) * addedNew;
        int totalFuel = stack1Fuel + stack2Fuel;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Fuel", totalFuel / (slotStack.m_41613_() + addedNew));
        if (addedNew > 0) {
            slotStack.m_41769_(addedNew);
            slotStack.m_41751_(nbt);
            otherStack.m_41764_(otherStack.m_41613_() - addedNew);
            return true;
        }
        return super.m_142305_(slotStack, otherStack, slot, clickAction, player, slotAccess);
    }
}

