/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.hardcore_torches.item;

import com.github.wolfiewaffle.hardcore_torches.blockentity.FuelBlockEntity;
import com.github.wolfiewaffle.hardcore_torches.blockentity.IFuelBlock;
import com.github.wolfiewaffle.hardcore_torches.config.Config;
import java.awt.Color;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class OilCanItem
extends Item {
    public OilCanItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        int maxFuel = (Integer)Config.maxCanFuel.get();
        int fuel = OilCanItem.getFuel(stack);
        if (maxFuel != 0) {
            return Math.round(13.0f - (float)(maxFuel - fuel) * 13.0f / (float)maxFuel);
        }
        return 0;
    }

    public int m_142159_(ItemStack stack) {
        return Color.HSBtoRGB(0.5f, 1.0f, 1.0f);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        CompoundTag oldNbt = null;
        CompoundTag newNbt = null;
        if (oldStack.m_41783_() != null) {
            oldNbt = oldStack.m_41783_().m_6426_();
            oldNbt.m_128473_("Fuel");
        }
        if (newStack.m_41783_() != null) {
            newNbt = newStack.m_41783_().m_6426_();
            newNbt.m_128473_("Fuel");
        }
        if (oldNbt == null && newNbt != null) {
            return true;
        }
        if (oldNbt != null && newNbt == null) {
            return true;
        }
        if (oldNbt == null && newNbt == null) {
            return false;
        }
        return oldNbt.equals(null);
    }

    public static int getFuel(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof OilCanItem)) {
            return 0;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("Fuel")) {
            return nbt.m_128451_("Fuel");
        }
        return 0;
    }

    public static ItemStack setFuel(ItemStack stack, int fuel) {
        if (stack.m_41720_() instanceof OilCanItem) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            nbt.m_128405_("Fuel", Math.max(0, Math.min((Integer)Config.maxCanFuel.get(), fuel)));
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static ItemStack addFuel(ItemStack stack, int amount) {
        if (stack.m_41720_() instanceof OilCanItem) {
            CompoundTag nbt = stack.m_41783_();
            int fuel = 0;
            if (nbt != null) {
                fuel = nbt.m_128451_("Fuel");
            } else {
                nbt = new CompoundTag();
            }
            fuel = Math.min((Integer)Config.maxCanFuel.get(), Math.max(0, fuel + amount));
            nbt.m_128405_("Fuel", fuel);
            stack.m_41751_(nbt);
        }
        return stack;
    }

    public static boolean fuelBlock(FuelBlockEntity be, Level world, ItemStack stack) {
        if (!world.f_46443_) {
            int maxFromCan = 0;
            Block block = be.m_58900_().m_60734_();
            if (block instanceof IFuelBlock) {
                int maxFuel = ((IFuelBlock)block).getMaxFuel();
                maxFromCan = Math.max(0, maxFuel - be.getFuel());
            }
            int taken = Math.min(maxFromCan, OilCanItem.getFuel(stack));
            OilCanItem.addFuel(stack, -taken);
            be.setFuel(be.getFuel() + taken);
            return taken > 0;
        }
        return false;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        super.m_6787_(tab, stacks);
        if (this.m_220152_(tab)) {
            stacks.add((Object)OilCanItem.setFuel(new ItemStack((ItemLike)this), (Integer)Config.maxCanFuel.get()));
        }
    }
}

