/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import hunternif.mc.impl.atlas.core.TileIdMap;
import hunternif.mc.impl.atlas.structure.StructureHandler;
import hunternif.mc.impl.atlas.util.MathUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;

public class NetherFortress {
    public static Collection<ChunkPos> bridgeX(Level world, StructurePoolElement element, BoundingBox box, StructurePiece piece) {
        HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
        if (box.m_71056_() > 16) {
            int chunkZ = MathUtil.getCenter(box).m_123343_() >> 4;
            for (int x = box.m_162395_(); x < box.m_162399_(); x += 16) {
                matches.add(new ChunkPos(x >> 4, chunkZ));
            }
        }
        return matches;
    }

    public static Collection<ChunkPos> bridgeZ(Level world, StructurePoolElement element, BoundingBox box, StructurePiece piece) {
        HashSet<ChunkPos> matches = new HashSet<ChunkPos>();
        if (box.m_71058_() > 16) {
            int chunkX = MathUtil.getCenter(box).m_123341_() >> 4;
            for (int z = box.m_162398_(); z < box.m_162401_(); z += 16) {
                matches.add(new ChunkPos(chunkX, z >> 4));
            }
        }
        return matches;
    }

    public static Collection<ChunkPos> bridgeEndX(Level world, StructurePoolElement element, BoundingBox box, StructurePiece piece) {
        if (box.m_71056_() > box.m_71058_()) {
            return Collections.singleton(new ChunkPos(box.m_162394_().m_123341_() >> 4, box.m_162394_().m_123343_() >> 4));
        }
        return Collections.emptySet();
    }

    public static Collection<ChunkPos> bridgeEndZ(Level world, StructurePoolElement element, BoundingBox box, StructurePiece piece) {
        if (box.m_71058_() > box.m_71056_()) {
            return Collections.singleton(new ChunkPos(box.m_162394_().m_123341_() >> 4, box.m_162394_().m_123343_() >> 4));
        }
        return Collections.emptySet();
    }

    public static void registerPieces() {
        StructureHandler.registerTile(StructurePieceType.f_210140_, 40, TileIdMap.NETHER_FORTRESS_BRIDGE_PLATFORM);
        StructureHandler.registerTile(StructurePieceType.f_210142_, 50, TileIdMap.NETHER_FORTRESS_BRIDGE_STAIRS);
        StructureHandler.registerTile(StructurePieceType.f_210139_, 50, TileIdMap.NETHER_FORTRESS_CORRIDOR_NETHER_WARTS_ROOM);
        StructureHandler.registerTile(StructurePieceType.f_210141_, 60, TileIdMap.NETHER_FORTRESS_BRIDGE_SMALL_CROSSING);
        StructureHandler.registerTile(StructurePieceType.f_210133_, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(StructurePieceType.f_210136_, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(StructurePieceType.f_210137_, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(StructurePieceType.f_210138_, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(StructurePieceType.f_210143_, 70, TileIdMap.NETHER_FORTRESS_WALL);
        StructureHandler.registerTile(StructurePieceType.f_210134_, 70, TileIdMap.NETHER_FORTRESS_EXIT);
        StructureHandler.registerTile(StructurePieceType.f_210129_, 80, TileIdMap.NETHER_FORTRESS_BRIDGE_CROSSING);
        StructureHandler.registerTile(StructurePieceType.f_210130_, 90, TileIdMap.NETHER_BRIDGE_END_X, NetherFortress::bridgeEndX);
        StructureHandler.registerTile(StructurePieceType.f_210130_, 90, TileIdMap.NETHER_BRIDGE_END_Z, NetherFortress::bridgeEndZ);
        StructureHandler.registerTile(StructurePieceType.f_210131_, 100, TileIdMap.NETHER_BRIDGE_X, NetherFortress::bridgeX);
        StructureHandler.registerTile(StructurePieceType.f_210131_, 100, TileIdMap.NETHER_BRIDGE_Z, NetherFortress::bridgeZ);
    }
}

