/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.structure;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.structure.StructureHandler;
import hunternif.mc.impl.atlas.structure.StructurePieceTile;
import hunternif.mc.impl.atlas.structure.StructurePieceTileXZ;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class JigsawConfig
implements ResourceReloadListener<Map<ResourceLocation, StructurePieceTile>> {
    private static final ResourceLocation ID = AntiqueAtlasMod.id("structures");
    public static final Map<ResourceLocation, StructurePieceTile> PIECES = new ConcurrentHashMap<ResourceLocation, StructurePieceTile>();

    private static JsonObject readResource(ResourceManager manager, ResourceLocation id) throws IOException {
        Resource resource = (Resource)manager.m_213713_(id).orElseThrow(IOException::new);
        try (InputStream stream = resource.m_215507_();){
            JsonObject jsonObject;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            return jsonObject;
        }
    }

    private static StructurePieceTile parseJson(JsonObject json) {
        int version = json.getAsJsonPrimitive("version").getAsInt();
        if (version == 1) {
            return new StructurePieceTile(ResourceLocation.m_135820_((String)json.get("tile").getAsString()), json.get("priority").getAsInt());
        }
        if (version == 2) {
            return new StructurePieceTileXZ(ResourceLocation.m_135820_((String)json.get("tile_x").getAsString()), ResourceLocation.m_135820_((String)json.get("tile_z").getAsString()), json.get("priority").getAsInt());
        }
        throw new RuntimeException("Unsupported JSON version: " + version + ". Only version 1 is supported.");
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, StructurePieceTile>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, StructurePieceTile> pieces = new HashMap<ResourceLocation, StructurePieceTile>();
            try {
                for (ResourceLocation id2 : manager.m_214159_("atlas/structures", id -> id.toString().endsWith(".json")).keySet()) {
                    AntiqueAtlasMod.LOG.info("Found structure piece config: " + String.valueOf(id2));
                    try {
                        ResourceLocation piece_id = new ResourceLocation(id2.m_135827_(), id2.m_135815_().replace("atlas/structures/", "").replace(".json", ""));
                        JsonObject json = JigsawConfig.readResource(manager, id2);
                        pieces.put(piece_id, JigsawConfig.parseJson(json));
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading structure piece config from " + String.valueOf(id2), (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                AntiqueAtlasMod.LOG.warn("Failed to read structure piece mapping from data pack!", e);
            }
            return pieces;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, StructurePieceTile> pieces, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> pieces.forEach((id, piece) -> {
            AntiqueAtlasMod.LOG.info("Apply structure piece config: " + String.valueOf(id));
            if (piece instanceof StructurePieceTileXZ) {
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTileX(), StructureHandler::IF_X_DIRECTION);
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTileZ(), StructureHandler::IF_Z_DIRECTION);
            } else {
                StructureHandler.registerJigsawTile(id, piece.getPriority(), piece.getTile());
            }
        }), executor);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }
}

