/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core.scanning;

import hunternif.mc.api.AtlasAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileInfo;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.core.scanning.ITileDetector;
import hunternif.mc.impl.atlas.core.scanning.TileDetectorBase;
import hunternif.mc.impl.atlas.core.scanning.TileDetectorEnd;
import hunternif.mc.impl.atlas.core.scanning.TileDetectorNether;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;

public class WorldScanner {
    private final Map<ResourceKey<Level>, ITileDetector> biomeAnalyzers = new HashMap<ResourceKey<Level>, ITileDetector>();
    private final TileDetectorBase tileDetectorOverworld = new TileDetectorBase();

    public WorldScanner() {
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.f_46428_, this.tileDetectorOverworld);
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.f_46429_, new TileDetectorNether());
        this.setBiomeDetectorForWorld((ResourceKey<Level>)Level.f_46430_, new TileDetectorEnd());
    }

    private ITileDetector getBiomeDetectorForWorld(ResourceKey<Level> world) {
        ITileDetector biomeAnalyzer = this.biomeAnalyzers.get(world);
        return biomeAnalyzer == null ? this.tileDetectorOverworld : biomeAnalyzer;
    }

    private void setBiomeDetectorForWorld(ResourceKey<Level> world, ITileDetector biomeAnalyzer) {
        this.biomeAnalyzers.put(world, biomeAnalyzer);
    }

    public Collection<TileInfo> updateAtlasAroundPlayer(AtlasData data, Player player) {
        int newScanInterval = Math.round(AntiqueAtlasMod.CONFIG.newScanInterval * 20.0f);
        if (player.m_20193_().m_46467_() % (long)newScanInterval != 0L) {
            return Collections.emptyList();
        }
        ArrayList<TileInfo> updatedTiles = new ArrayList<TileInfo>();
        int rescanInterval = newScanInterval * AntiqueAtlasMod.CONFIG.rescanRate;
        boolean rescanRequired = AntiqueAtlasMod.CONFIG.doRescan && player.m_20193_().m_46467_() % (long)rescanInterval == 0L;
        ITileDetector biomeDetector = this.getBiomeDetectorForWorld((ResourceKey<Level>)player.m_20193_().m_46472_());
        int scanRadius = biomeDetector.getScanRadius();
        for (int dx = -scanRadius; dx <= scanRadius; ++dx) {
            for (int dz = -scanRadius; dz <= scanRadius; ++dz) {
                if (dx * dx + dz * dz > scanRadius * scanRadius) continue;
                int chunkX = player.m_146902_().f_45578_ + dx;
                int chunkZ = player.m_146902_().f_45579_ + dz;
                TileInfo update = this.updateAtlasForChunk(data, player.m_20193_(), chunkX, chunkZ, rescanRequired);
                if (update == null) continue;
                updatedTiles.add(update);
            }
        }
        return updatedTiles;
    }

    private TileInfo updateAtlasForChunk(AtlasData data, Level world, int x, int z, boolean rescanRequired) {
        WorldData storedData = data.getWorldData((ResourceKey<Level>)world.m_46472_());
        ResourceLocation oldTile = storedData.getTile(x, z);
        ResourceLocation tile = AtlasAPI.getTileAPI().getGlobalTile(world, x, z);
        if (tile == null) {
            if (oldTile != null && !rescanRequired) {
                return null;
            }
            if (!world.m_7726_().m_5563_(x, z)) {
                return null;
            }
            ChunkAccess chunk = world.m_6522_(x, z, ChunkStatus.f_62326_, AntiqueAtlasMod.CONFIG.forceChunkLoading);
            if (chunk == null) {
                return null;
            }
            ITileDetector biomeDetector = this.getBiomeDetectorForWorld((ResourceKey<Level>)world.m_46472_());
            tile = biomeDetector.getBiomeID(world, chunk);
            if (oldTile != null) {
                if (tile == null) {
                    data.removeTile((ResourceKey<Level>)world.m_46472_(), x, z);
                } else if (!oldTile.equals((Object)tile)) {
                    data.setTile((ResourceKey<Level>)world.m_46472_(), x, z, tile);
                    return new TileInfo(x, z, tile);
                }
            } else if (tile != null) {
                data.setTile((ResourceKey<Level>)world.m_46472_(), x, z, tile);
                return new TileInfo(x, z, tile);
            }
        } else if (oldTile == null || !oldTile.equals((Object)tile)) {
            data.setTile((ResourceKey<Level>)world.m_46472_(), x, z, tile);
            data.m_77762_();
            return new TileInfo(x, z, tile);
        }
        return null;
    }
}

