/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.core;

import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.ITileStorage;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.network.packet.s2c.play.TileGroupsS2CPacket;
import hunternif.mc.impl.atlas.util.Log;
import hunternif.mc.impl.atlas.util.Rect;
import hunternif.mc.impl.atlas.util.Streams;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class WorldData
implements ITileStorage {
    public final AtlasData parent;
    public final ResourceKey<Level> world;
    private int browsingX;
    private int browsingY;
    private double browsingZoom = 0.5;
    private final Map<ChunkPos, TileGroup> tileGroups = new ConcurrentHashMap<ChunkPos, TileGroup>(2, 0.75f, 2);
    private final Rect scope = new Rect();

    public WorldData(AtlasData parent, ResourceKey<Level> world) {
        this.parent = parent;
        this.world = world;
    }

    public Map<ChunkPos, ResourceLocation> getSeenChunks() {
        ConcurrentHashMap<ChunkPos, ResourceLocation> chunks = new ConcurrentHashMap<ChunkPos, ResourceLocation>(2, 0.75f, 2);
        for (Map.Entry<ChunkPos, TileGroup> entry : this.tileGroups.entrySet()) {
            int basex = entry.getValue().getScope().minX;
            int basey = entry.getValue().getScope().minY;
            for (int x = basex; x < basex + 16; ++x) {
                for (int y = basey; y < basey + 16; ++y) {
                    ResourceLocation t = entry.getValue().getTile(x, y);
                    if (t == null) continue;
                    chunks.put(new ChunkPos(x, y), t);
                }
            }
        }
        return chunks;
    }

    public void setBrowsingPosition(int x, int y, double zoom) {
        this.browsingX = x;
        this.browsingY = y;
        this.browsingZoom = zoom;
        if (this.browsingZoom <= 0.0) {
            Log.warn("Setting map zoom to invalid value of %f", zoom);
            this.browsingZoom = AntiqueAtlasMod.CONFIG.minScale;
        }
        this.parent.m_77762_();
    }

    public void setBrowsingPositionTo(Entity e) {
        this.setBrowsingPosition((int)Math.round(-e.m_20185_() * AntiqueAtlasMod.CONFIG.defaultScale), (int)Math.round(-e.m_20189_() * AntiqueAtlasMod.CONFIG.defaultScale), AntiqueAtlasMod.CONFIG.defaultScale);
    }

    public int getBrowsingX() {
        return this.browsingX;
    }

    public int getBrowsingY() {
        return this.browsingY;
    }

    public double getBrowsingZoom() {
        return this.browsingZoom;
    }

    @Override
    public void setTile(int x, int y, ResourceLocation tile) {
        ChunkPos groupPos = new ChunkPos((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            tg = new TileGroup(groupPos.f_45578_ * 16, groupPos.f_45579_ * 16);
            this.tileGroups.put(groupPos, tg);
        }
        tg.setTile(x, y, tile);
        this.scope.extendTo(x, y);
        this.parent.m_77762_();
    }

    public void putTileGroup(TileGroup t) {
        ChunkPos key = new ChunkPos(Math.floorDiv(t.scope.minX, 16), Math.floorDiv(t.scope.minY, 16));
        this.tileGroups.put(key, t);
        this.extendToTileGroup(t);
    }

    @Override
    public ResourceLocation removeTile(int x, int y) {
        return this.getTile(x, y);
    }

    @Override
    public ResourceLocation getTile(int x, int y) {
        ChunkPos groupPos = new ChunkPos((int)Math.floor((float)x / 16.0f), (int)Math.floor((float)y / 16.0f));
        TileGroup tg = this.tileGroups.get(groupPos);
        if (tg == null) {
            return null;
        }
        return tg.getTile(x, y);
    }

    @Override
    public boolean hasTileAt(int x, int y) {
        return this.getTile(x, y) != null;
    }

    @Override
    public Rect getScope() {
        return this.scope;
    }

    public WorldData clone() {
        WorldData data = new WorldData(this.parent, this.world);
        data.tileGroups.putAll(this.tileGroups);
        data.scope.set(this.scope);
        return data;
    }

    public void addData(WorldData other) {
        for (Map.Entry<ChunkPos, TileGroup> e : other.tileGroups.entrySet()) {
            TileGroup group = e.getValue();
            Rect s = group.getScope();
            for (int x = s.minX; x <= s.maxX; ++x) {
                for (int y = s.minY; y <= s.maxY; ++y) {
                    ResourceLocation tile = group.getTile(x, y);
                    if (tile == null) continue;
                    this.setTile(x, y, tile);
                }
            }
        }
    }

    public ListTag writeToNBT() {
        ListTag tileGroupList = new ListTag();
        for (Map.Entry<ChunkPos, TileGroup> entry : this.tileGroups.entrySet()) {
            CompoundTag newbie = new CompoundTag();
            entry.getValue().writeToNBT(newbie);
            tileGroupList.add((Object)newbie);
        }
        return tileGroupList;
    }

    private void extendToTileGroup(TileGroup tg) {
        for (int x = tg.scope.minX; x <= tg.scope.maxX; ++x) {
            for (int y = tg.scope.minY; y <= tg.scope.maxY; ++y) {
                if (!tg.hasTileAt(x, y)) continue;
                this.scope.extendTo(x, y);
            }
        }
    }

    public void readFromNBT(ListTag me) {
        if (me == null) {
            return;
        }
        for (int d = 0; d < me.size(); ++d) {
            CompoundTag tgTag = me.m_128728_(d);
            TileGroup tg = new TileGroup(0, 0);
            tg.readFromNBT(tgTag);
            this.putTileGroup(tg);
        }
    }

    public void syncToPlayer(int atlasID, Player player) {
        Log.info("Sending dimension #%s", this.world.toString());
        Streams.chunked(this.tileGroups.values().stream(), 100).forEach(chunk -> new TileGroupsS2CPacket(atlasID, this.world, (List<TileGroup>)chunk).send((ServerPlayer)player));
        Log.info("Sent dimension #%s (%d tiles)", this.world.toString(), this.tileGroups.size());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldData)) {
            return false;
        }
        WorldData other = (WorldData)obj;
        if (other.tileGroups.size() != this.tileGroups.size()) {
            return false;
        }
        for (ChunkPos entry : this.tileGroups.keySet()) {
            if (this.tileGroups.get(entry).equals(other.tileGroups.get(entry))) continue;
            return false;
        }
        return true;
    }
}

