/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;

public class GuiArrowButton
extends GuiComponentButton {
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;
    private final ArrowDirection direction;

    private GuiArrowButton(ArrowDirection direction) {
        this.setSize(12, 12);
        this.direction = direction;
    }

    static GuiArrowButton up() {
        return new GuiArrowButton(ArrowDirection.UP);
    }

    static GuiArrowButton down() {
        return new GuiArrowButton(ArrowDirection.DOWN);
    }

    static GuiArrowButton left() {
        return new GuiArrowButton(ArrowDirection.LEFT);
    }

    static GuiArrowButton right() {
        return new GuiArrowButton(ArrowDirection.RIGHT);
    }

    @Override
    public void m_6305_(PoseStack context, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        int x = this.getGuiX();
        int y = this.getGuiY();
        if (this.isMouseOver) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int distanceSq = (mouseX - x - this.getWidth() / 2) * (mouseX - x - this.getWidth() / 2) + (mouseY - y - this.getHeight() / 2) * (mouseY - y - this.getHeight() / 2);
            double alpha = distanceSq < 400 ? 0.5 : Math.pow(distanceSq, -0.28);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)alpha));
        }
        int u = 0;
        int v = 0;
        switch (this.direction) {
            case LEFT: {
                u = 0;
                v = 0;
                break;
            }
            case RIGHT: {
                u = 0;
                v = 12;
                break;
            }
            case UP: {
                u = 12;
                v = 0;
                break;
            }
            case DOWN: {
                u = 12;
                v = 12;
            }
        }
        Textures.BTN_ARROWS.draw(context, x, y, u, v, 12, 12);
        RenderSystem.m_69461_();
    }

    public static enum ArrowDirection {
        UP("Up"),
        DOWN("Down"),
        LEFT("Left"),
        RIGHT("Right");

        public final String description;

        private ArrowDirection(String text) {
            this.description = text;
        }
    }
}

