/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.TextureSet;
import hunternif.mc.impl.atlas.client.TextureSetConfig;
import hunternif.mc.impl.atlas.client.TextureSetMap;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.core.scanning.TileHeightType;
import hunternif.mc.impl.atlas.resource.ResourceReloadListener;
import hunternif.mc.impl.atlas.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileTextureConfig
implements ResourceReloadListener<Map<ResourceLocation, ResourceLocation>> {
    public static final ResourceLocation ID = AntiqueAtlasMod.id("tile_textures");
    private final TileTextureMap tileTextureMap;
    private final TextureSetMap textureSetMap;

    public TileTextureConfig(TileTextureMap biomeTextureMap, TextureSetMap textureSetMap) {
        this.tileTextureMap = biomeTextureMap;
        this.textureSetMap = textureSetMap;
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, ResourceLocation>> load(ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, ResourceLocation> map = new HashMap<ResourceLocation, ResourceLocation>();
            try {
                for (ResourceLocation id2 : manager.m_214159_("atlas/tiles", id -> id.toString().endsWith(".json")).keySet()) {
                    ResourceLocation tile_id = new ResourceLocation(id2.m_135827_(), id2.m_135815_().replace("atlas/tiles/", "").replace(".json", ""));
                    try {
                        Resource resource = (Resource)manager.m_213713_(id2).orElseThrow(IOException::new);
                        InputStream stream = resource.m_215507_();
                        try (InputStreamReader reader = new InputStreamReader(stream);){
                            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            int version = object.getAsJsonPrimitive("version").getAsInt();
                            if (version == 1) {
                                ResourceLocation texture_set = new ResourceLocation(object.get("texture_set").getAsString());
                                map.put(tile_id, texture_set);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    map.put(ResourceLocation.m_135820_((String)(String.valueOf(tile_id) + "_" + layer.getName())), texture_set);
                                }
                                continue;
                            }
                            if (version == 2) {
                                ResourceLocation default_entry = TileTextureMap.DEFAULT_TEXTURE;
                                try {
                                    default_entry = new ResourceLocation(object.getAsJsonObject("texture_sets").get("default").getAsString());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                map.put(tile_id, default_entry);
                                for (TileHeightType layer : TileHeightType.values()) {
                                    ResourceLocation texture_set = default_entry;
                                    try {
                                        texture_set = new ResourceLocation(object.getAsJsonObject("texture_sets").get(layer.getName()).getAsString());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    map.put(ResourceLocation.m_135820_((String)(String.valueOf(tile_id) + "_" + String.valueOf((Object)layer))), texture_set);
                                }
                                continue;
                            }
                            AntiqueAtlasMod.LOG.warn("The tile " + String.valueOf(tile_id) + " is in the wrong version! Skipping.");
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        AntiqueAtlasMod.LOG.warn("Error reading tile mapping " + String.valueOf(tile_id) + "!", (Throwable)e);
                    }
                }
            }
            catch (Throwable e) {
                Log.warn(e, "Failed to read tile mappings!", new Object[0]);
            }
            return map;
        }, executor);
    }

    @Override
    public CompletableFuture<Void> apply(Map<ResourceLocation, ResourceLocation> tileMap, ResourceManager manager, ProfilerFiller profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> {
            for (Map.Entry entry : tileMap.entrySet()) {
                ResourceLocation tile_id = (ResourceLocation)entry.getKey();
                ResourceLocation texture_set = (ResourceLocation)entry.getValue();
                TextureSet set = this.textureSetMap.getByName((ResourceLocation)entry.getValue());
                if (set == null) {
                    AntiqueAtlasMod.LOG.error("Missing texture set `{}` for tile `{}`. Using default.", (Object)texture_set, (Object)tile_id);
                    set = this.tileTextureMap.getDefaultTexture();
                }
                this.tileTextureMap.setTexture((ResourceLocation)entry.getKey(), set);
                if (!AntiqueAtlasMod.CONFIG.resourcePackLogging) continue;
                Log.info("Loaded tile %s with texture set %s", tile_id, set.name);
            }
        }, executor);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return Collections.singleton(TextureSetConfig.ID);
    }
}

