/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import hunternif.mc.api.AtlasAPI;
import hunternif.mc.api.client.AtlasClientAPI;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.client.SetTileRenderer;
import hunternif.mc.impl.atlas.client.SubTile;
import hunternif.mc.impl.atlas.client.SubTileQuartet;
import hunternif.mc.impl.atlas.client.Textures;
import hunternif.mc.impl.atlas.client.TileRenderIterator;
import hunternif.mc.impl.atlas.client.TileTextureMap;
import hunternif.mc.impl.atlas.client.gui.GuiAtlas;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.marker.DimensionMarkersData;
import hunternif.mc.impl.atlas.marker.Marker;
import hunternif.mc.impl.atlas.marker.MarkersData;
import hunternif.mc.impl.atlas.registry.MarkerRenderInfo;
import hunternif.mc.impl.atlas.registry.MarkerType;
import hunternif.mc.impl.atlas.util.Rect;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OverlayRenderer {
    private static final int CHUNK_SIZE = 16;
    private static final float INNER_ELEMENTS_SCALE_FACTOR = 1.9f;
    private Player player;
    private Level world;

    public void drawOverlay(PoseStack matrices, MultiBufferSource vertexConsumer, int light) {
        if (Minecraft.m_91087_().f_91080_ instanceof GuiAtlas) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_ == null || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        this.player = Minecraft.m_91087_().f_91074_;
        this.world = Minecraft.m_91087_().f_91073_;
        this.drawMinimap(matrices, AtlasAPI.getPlayerAtlasId(this.player), vertexConsumer, light);
    }

    private void drawMinimap(PoseStack matrices, int atlasID, MultiBufferSource buffer, int light) {
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 0.01);
        Textures.BOOK.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        matrices.m_85849_();
        matrices.m_85836_();
        matrices.m_85841_(1.9f, 1.9f, 1.0f);
        this.drawTiles(buffer, matrices, atlasID, light);
        matrices.m_85837_(0.0, 0.0, -0.01);
        if (AntiqueAtlasMod.CONFIG.markerSize > 0) {
            this.drawMarkers(buffer, matrices, atlasID, light);
        }
        matrices.m_85849_();
        matrices.m_85837_(0.0, 0.0, -0.02);
        this.drawPlayer(buffer, matrices, light);
        matrices.m_85837_(0.0, 0.0, -0.01);
        Textures.BOOK_FRAME.drawWithLight(buffer, matrices, 0, 0, 465, 327, light);
        RenderSystem.m_69461_();
    }

    private void drawTiles(MultiBufferSource buffer, PoseStack matrices, int atlasID, int light) {
        Rect iteratorScope = this.getChunkCoverage(this.player.m_20182_());
        TileRenderIterator iter = AtlasClientAPI.getTileAPI().getTiles(this.world, atlasID, iteratorScope, 1);
        Vec3 chunkPosition = this.player.m_20182_().m_82542_(0.0625, 0.0625, 0.0625);
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        SetTileRenderer renderer = new SetTileRenderer(buffer, matrices, AntiqueAtlasMod.CONFIG.tileSize / 2, light);
        while (iter.hasNext()) {
            SubTileQuartet subtiles = iter.next();
            for (SubTile subtile : subtiles) {
                if (subtile == null || subtile.tile == null) continue;
                float relativeChunkPositionX = (float)((double)subtile.x / 2.0 + (double)iteratorScope.minX - chunkPosition.f_82479_);
                float relativeChunkPositionY = (float)((double)subtile.y / 2.0 + (double)iteratorScope.minY - chunkPosition.f_82481_);
                renderer.addTileCorner(TileTextureMap.instance().getTexture(subtile).getTexture(), shapeMiddleX + (int)Math.floor(relativeChunkPositionX * (float)AntiqueAtlasMod.CONFIG.tileSize), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * (float)AntiqueAtlasMod.CONFIG.tileSize), subtile.getTextureU(), subtile.getTextureV());
            }
        }
        renderer.draw();
    }

    private void drawMarkers(MultiBufferSource buffer, PoseStack matrices, int atlasID, int light) {
        WorldData biomeData = AntiqueAtlasMod.tileData.getData(atlasID, this.world).getWorldData((ResourceKey<Level>)this.world.m_46472_());
        DimensionMarkersData globalMarkersData = AntiqueAtlasMod.globalMarkersData.getData().getMarkersDataInWorld((ResourceKey<Level>)this.world.m_46472_());
        this.drawMarkersData(buffer, matrices, globalMarkersData, biomeData, light);
        MarkersData markersData = AntiqueAtlasMod.markersData.getMarkersData(atlasID, (Level)Minecraft.m_91087_().f_91073_);
        if (markersData != null) {
            DimensionMarkersData localMarkersData = markersData.getMarkersDataInWorld((ResourceKey<Level>)this.world.m_46472_());
            this.drawMarkersData(buffer, matrices, localMarkersData, biomeData, light);
        }
    }

    private void drawPlayer(MultiBufferSource buffer, PoseStack matrices, int light) {
        matrices.m_85836_();
        matrices.m_85837_(232.0, 163.0, 0.0);
        matrices.m_85845_(new Quaternion(Vector3f.f_122227_, this.player.m_6080_() + 180.0f, true));
        matrices.m_85837_((double)(-AntiqueAtlasMod.CONFIG.playerIconWidth) / 2.0, (double)(-AntiqueAtlasMod.CONFIG.playerIconHeight) / 2.0, 0.0);
        Textures.PLAYER.drawWithLight(buffer, matrices, 0, 0, AntiqueAtlasMod.CONFIG.playerIconWidth, AntiqueAtlasMod.CONFIG.playerIconHeight, light);
        matrices.m_85849_();
    }

    private void drawMarkersData(MultiBufferSource buffer, PoseStack matrices, DimensionMarkersData markersData, WorldData biomeData, int light) {
        Rect mcchunks = this.getChunkCoverage(this.player.m_20182_());
        Rect chunks = new Rect(mcchunks.minX / 8, mcchunks.minY / 8, (int)Math.ceil((float)mcchunks.maxX / 8.0f), (int)Math.ceil((float)mcchunks.maxY / 8.0f));
        int shapeMiddleX = 122;
        int shapeMiddleY = 86;
        Vec3 chunkPosition = this.player.m_20182_().m_82542_(0.0625, 0.0625, 0.0625);
        for (int x = chunks.minX; x <= chunks.maxX; ++x) {
            for (int z = chunks.minY; z <= chunks.maxY; ++z) {
                List<Marker> markers = markersData.getMarkersAtChunk(x, z);
                if (markers == null) continue;
                for (Marker marker : markers) {
                    float relativeChunkPositionX = (float)((double)marker.getChunkX() - chunkPosition.f_82479_);
                    float relativeChunkPositionY = (float)((double)marker.getChunkZ() - chunkPosition.f_82481_);
                    this.renderMarker(buffer, matrices, marker, shapeMiddleX + (int)Math.floor(relativeChunkPositionX * 8.0f), shapeMiddleY + (int)Math.floor(relativeChunkPositionY * 8.0f), biomeData, light);
                }
            }
        }
    }

    private void renderMarker(MultiBufferSource buffer, PoseStack matrices, Marker marker, int x, int y, WorldData biomeData, int light) {
        int tileHalfSize = 2;
        if (x + tileHalfSize > 240 || x - tileHalfSize < 3 || y + tileHalfSize >= 166 || y - tileHalfSize < 0) {
            return;
        }
        if (!marker.isVisibleAhead() && !biomeData.hasTileAt(marker.getChunkX(), marker.getChunkZ())) {
            return;
        }
        MarkerType type = (MarkerType)MarkerType.REGISTRY.m_7745_(marker.getType());
        MarkerRenderInfo info = type.getRenderInfo(1.0, AntiqueAtlasMod.CONFIG.tileSize, 1.0);
        info.tex.drawWithLight(buffer, matrices, x - 8 + 4, y - 8 + 4, 16, 16, light);
    }

    private Rect getChunkCoverage(Vec3 position) {
        int minChunkX = (int)Math.floor(position.f_82479_ / 16.0 - (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int minChunkY = (int)Math.floor(position.f_82481_ / 16.0 - (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkX = (int)Math.ceil(position.f_82479_ / 16.0 + (double)(310.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        int maxChunkY = (int)Math.ceil(position.f_82481_ / 16.0 + (double)(218.0f / (4.0f * (float)AntiqueAtlasMod.CONFIG.tileSize)));
        return new Rect(minChunkX -= 4, minChunkY -= 3, maxChunkX += 4, maxChunkY += 2);
    }
}

