/*
 * Decompiled with CFR 0.152.
 */
package com.caveore.config;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfiguration {
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> caveblocks;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> excludedOres;
    public final ForgeConfigSpec.ConfigValue<Integer> spawnchance;
    public final ForgeConfigSpec.ConfigValue<Double> airChance;
    public final ForgeConfigSpec.ConfigValue<Boolean> inverted;

    protected CommonConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("Ore settings");
        builder.comment("List of blocks to which ores are allowed to spawn next to. This does not override existing spawn restrictions of the ores, as those are restrictions on the block they can spawn instead of.  e.g. format :  [\"minecraft:air\", \"minecraft:cave_air\"]");
        this.caveblocks = builder.defineList("caveblocks", (List)Lists.newArrayList((Object[])new String[]{"minecraft:air", "minecraft:cave_air", "minecraft:water", "minecraft:lava"}), e -> e instanceof String && ((String)e).contains(":"));
        builder.comment("List of excluded ores beeing affected, these are mod-specific. : e.g. format :  [\"mod:orename\", \"minecraft:iron_ore\"]");
        this.excludedOres = builder.defineList("excludedOres", Collections.emptyList(), e -> e instanceof String && ((String)e).contains(":"));
        builder.comment("Invert the exluded list to an included only list, of which ores are affected. Default = false");
        this.inverted = builder.define("inverted", false);
        builder.comment("Chance for an ore vein to appear, reduced below 100% to reduce spawn rates.");
        this.spawnchance = builder.defineInRange("spawnchance", 100, 1, 100);
        builder.comment("Alters chance of ores to not get spawned on air, increase to have more ores spawning on air.");
        this.airChance = builder.defineInRange("airChance", 10.0, (double)0.1f, 100.0);
        builder.pop();
    }
}

