/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MeshImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractQuadRenderer;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemRenderContext
extends AbstractRenderContext {
    private static final long ITEM_RANDOM_SEED = 42L;
    private final ItemColors colorMap;
    private final RandomSource random = RandomSource.m_216327_();
    private final Vector3f normalVec = new Vector3f();
    private final Supplier<RandomSource> randomSupplier = () -> {
        this.random.m_188584_(42L);
        return this.random;
    };
    private final Maker editorQuad = new Maker();
    private final MeshConsumer meshConsumer = new MeshConsumer();
    private final FallbackConsumer fallbackConsumer = new FallbackConsumer();
    private ItemStack itemStack;
    private ItemTransforms.TransformType transformMode;
    private PoseStack matrixStack;
    private MultiBufferSource vertexConsumerProvider;
    private int lightmap;
    private VanillaQuadHandler vanillaHandler;
    private boolean isDefaultTranslucent;
    private boolean isTranslucentDirect;
    private VertexConsumer translucentVertexConsumer;
    private VertexConsumer cutoutVertexConsumer;
    private VertexConsumer modelVertexConsumer;

    public ItemRenderContext(ItemColors colorMap) {
        this.colorMap = colorMap;
    }

    public void renderModel(ItemStack itemStack, ItemTransforms.TransformType transformMode, boolean invert, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int lightmap, int overlay, BakedModel model, VanillaQuadHandler vanillaHandler) {
        this.itemStack = itemStack;
        this.transformMode = transformMode;
        this.matrixStack = matrixStack;
        this.vertexConsumerProvider = vertexConsumerProvider;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.vanillaHandler = vanillaHandler;
        this.computeOutputInfo();
        this.matrix = matrixStack.m_85850_().m_85861_();
        this.normalMatrix = matrixStack.m_85850_().m_85864_();
        ((FabricBakedModel)model).emitItemQuads(itemStack, this.randomSupplier, this);
        this.itemStack = null;
        this.matrixStack = null;
        this.vanillaHandler = null;
        this.translucentVertexConsumer = null;
        this.cutoutVertexConsumer = null;
        this.modelVertexConsumer = null;
    }

    private void computeOutputInfo() {
        this.isDefaultTranslucent = true;
        this.isTranslucentDirect = true;
        Item item = this.itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            BlockState state = blockItem.m_40614_().m_49966_();
            RenderType renderLayer = ItemBlockRenderTypes.m_109282_((BlockState)state);
            if (renderLayer != RenderType.m_110466_()) {
                this.isDefaultTranslucent = false;
            }
            if (this.transformMode != ItemTransforms.TransformType.GUI && !this.transformMode.m_111841_()) {
                this.isTranslucentDirect = false;
            }
        }
        this.modelVertexConsumer = this.quadVertexConsumer(BlendMode.DEFAULT);
    }

    private VertexConsumer quadVertexConsumer(BlendMode blendMode) {
        boolean translucent;
        if (blendMode == BlendMode.DEFAULT) {
            translucent = this.isDefaultTranslucent;
        } else {
            boolean bl = translucent = blendMode == BlendMode.TRANSLUCENT;
        }
        if (translucent) {
            if (this.translucentVertexConsumer == null) {
                this.translucentVertexConsumer = this.isTranslucentDirect ? ItemRenderer.m_115222_((MultiBufferSource)this.vertexConsumerProvider, (RenderType)Sheets.m_110792_(), (boolean)true, (boolean)this.itemStack.m_41790_()) : (Minecraft.m_91085_() ? ItemRenderer.m_115211_((MultiBufferSource)this.vertexConsumerProvider, (RenderType)Sheets.m_110791_(), (boolean)true, (boolean)this.itemStack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)this.vertexConsumerProvider, (RenderType)Sheets.m_110792_(), (boolean)true, (boolean)this.itemStack.m_41790_()));
            }
            return this.translucentVertexConsumer;
        }
        if (this.cutoutVertexConsumer == null) {
            this.cutoutVertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)this.vertexConsumerProvider, (RenderType)Sheets.m_110790_(), (boolean)true, (boolean)this.itemStack.m_41790_());
        }
        return this.cutoutVertexConsumer;
    }

    private void bufferQuad(MutableQuadViewImpl quad, BlendMode blendMode) {
        AbstractQuadRenderer.bufferQuad(this.quadVertexConsumer(blendMode), quad, this.matrix, this.overlay, this.normalMatrix, this.normalVec);
    }

    private void colorizeQuad(MutableQuadViewImpl q, int colorIndex) {
        if (colorIndex == -1) {
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(q.spriteColor(i, 0)));
            }
        } else {
            int itemColor = 0xFF000000 | this.colorMap.m_92676_(this.itemStack, colorIndex);
            for (int i = 0; i < 4; ++i) {
                q.spriteColor(i, 0, ColorHelper.swapRedBlueIfNeeded(ColorHelper.multiplyColor(itemColor, q.spriteColor(i, 0))));
            }
        }
    }

    private void renderQuad(MutableQuadViewImpl quad, BlendMode blendMode, int colorIndex) {
        this.colorizeQuad(quad, colorIndex);
        int lightmap = this.lightmap;
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
        }
        this.bufferQuad(quad, blendMode);
    }

    private void renderQuadEmissive(MutableQuadViewImpl quad, BlendMode blendMode, int colorIndex) {
        this.colorizeQuad(quad, colorIndex);
        for (int i = 0; i < 4; ++i) {
            quad.lightmap(i, 0xF000F0);
        }
        this.bufferQuad(quad, blendMode);
    }

    private void renderMeshQuad(MutableQuadViewImpl quad) {
        if (!this.transform(quad)) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        int colorIndex = mat.disableColorIndex(0) ? -1 : quad.colorIndex();
        BlendMode blendMode = mat.blendMode(0);
        if (mat.emissive(0)) {
            this.renderQuadEmissive(quad, blendMode, colorIndex);
        } else {
            this.renderQuad(quad, blendMode, colorIndex);
        }
    }

    @Override
    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    @Override
    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.fallbackConsumer;
    }

    @Override
    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private class Maker
    extends MutableQuadViewImpl
    implements QuadEmitter {
        private Maker() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public Maker emit() {
            this.computeGeometry();
            ItemRenderContext.this.renderMeshQuad(this);
            this.clear();
            return this;
        }
    }

    private class MeshConsumer
    implements Consumer<Mesh> {
        private MeshConsumer() {
        }

        @Override
        public void accept(Mesh mesh) {
            MeshImpl m = (MeshImpl)mesh;
            int[] data = m.data();
            int limit = data.length;
            for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
                System.arraycopy(data, index, ItemRenderContext.this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
                ItemRenderContext.this.editorQuad.load();
                ItemRenderContext.this.renderMeshQuad(ItemRenderContext.this.editorQuad);
            }
        }
    }

    private class FallbackConsumer
    implements RenderContext.BakedModelConsumer {
        private FallbackConsumer() {
        }

        @Override
        public void accept(BakedModel model) {
            this.accept(model, null);
        }

        @Override
        public void accept(BakedModel model, @Nullable BlockState state) {
            if (ItemRenderContext.this.hasTransform()) {
                for (int i = 0; i <= 6; ++i) {
                    Direction cullFace = ModelHelper.faceFromIndex(i);
                    ItemRenderContext.this.random.m_188584_(42L);
                    List quads = model.m_213637_(state, cullFace, ItemRenderContext.this.random);
                    int count = quads.size();
                    if (count == 0) continue;
                    for (int j = 0; j < count; ++j) {
                        BakedQuad q = (BakedQuad)quads.get(j);
                        ItemRenderContext.this.editorQuad.fromVanilla(q, IndigoRenderer.MATERIAL_STANDARD, cullFace);
                        ItemRenderContext.this.renderMeshQuad(ItemRenderContext.this.editorQuad);
                    }
                }
            } else {
                ItemRenderContext.this.vanillaHandler.accept(model, ItemRenderContext.this.itemStack, ItemRenderContext.this.lightmap, ItemRenderContext.this.overlay, ItemRenderContext.this.matrixStack, ItemRenderContext.this.modelVertexConsumer);
            }
        }
    }

    @FunctionalInterface
    public static interface VanillaQuadHandler {
        public void accept(BakedModel var1, ItemStack var2, int var3, int var4, PoseStack var5, VertexConsumer var6);
    }
}

