/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.aocalc;

import com.mojang.math.Vector3f;
import java.util.BitSet;
import link.infra.indium.Indium;
import link.infra.indium.mixin.renderer.AccessAmbientOcclusionCalculator;
import link.infra.indium.renderer.aocalc.AoConfig;
import link.infra.indium.renderer.aocalc.AoFace;
import link.infra.indium.renderer.aocalc.AoFaceData;
import link.infra.indium.renderer.aocalc.VanillaAoHelper;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.mesh.QuadViewImpl;
import link.infra.indium.renderer.render.BlockRenderInfo;
import me.jellysquid.mods.sodium.client.model.light.data.LightDataAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;

public class AoCalculator {
    private static final int[][] VERTEX_MAP = new int[6][4];
    private final AccessAmbientOcclusionCalculator vanillaCalc;
    private final BlockRenderInfo blockInfo;
    private final LightDataAccess lightCache;
    private final AoFaceData[] faceData = new AoFaceData[12];
    private int completionFlags = 0;
    private final float[] w = new float[4];
    public final float[] ao = new float[4];
    public final int[] light = new int[4];
    private final float[] vanillaAoData = new float[Direction.values().length * 2];
    private final BitSet vanillaAoControlBits = new BitSet(3);
    private final int[] vertexData = new int[EncodingFormat.QUAD_STRIDE];
    AoFaceData tmpFace = new AoFaceData();
    private final Vector3f vertexNormal = new Vector3f();

    public AoCalculator(BlockRenderInfo blockInfo, LightDataAccess lightCache) {
        this.blockInfo = blockInfo;
        this.lightCache = lightCache;
        this.vanillaCalc = VanillaAoHelper.get();
        for (int i = 0; i < 12; ++i) {
            this.faceData[i] = new AoFaceData();
        }
    }

    public void clear() {
        this.completionFlags = 0;
    }

    public void compute(MutableQuadViewImpl quad, boolean isVanilla) {
        AoConfig config = Indium.AMBIENT_OCCLUSION_MODE;
        switch (config) {
            case VANILLA: {
                if (this.vanillaCalc == null) {
                    this.calcFastVanilla(quad);
                    break;
                }
                this.calcVanilla(quad);
                break;
            }
            case EMULATE: {
                this.calcFastVanilla(quad);
                break;
            }
            default: {
                if (isVanilla) {
                    this.calcFastVanilla(quad);
                    break;
                }
                this.calcEnhanced(quad);
                break;
            }
            case ENHANCED: {
                this.calcEnhanced(quad);
            }
        }
    }

    private void calcVanilla(MutableQuadViewImpl quad) {
        this.calcVanilla(quad, this.ao, this.light);
    }

    private void calcVanilla(MutableQuadViewImpl quad, float[] aoDest, int[] lightDest) {
        this.vanillaAoControlBits.clear();
        Direction face = quad.lightFace();
        quad.toVanilla(0, this.vertexData, 0, false);
        VanillaAoHelper.getQuadDimensions(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.vertexData, face, this.vanillaAoData, this.vanillaAoControlBits);
        this.vanillaCalc.indium$apply(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, quad.lightFace(), this.vanillaAoData, this.vanillaAoControlBits, quad.hasShade());
        System.arraycopy(this.vanillaCalc.indium$brightness(), 0, aoDest, 0, 4);
        System.arraycopy(this.vanillaCalc.indium$light(), 0, lightDest, 0, 4);
    }

    private void calcFastVanilla(MutableQuadViewImpl quad) {
        int flags = quad.geometryFlags();
        if ((flags & 4) == 0 && (flags & 2) != 0 && this.blockInfo.blockState.m_60838_((BlockGetter)this.blockInfo.blockView, this.blockInfo.blockPos)) {
            flags |= 4;
        }
        if ((flags & 1) == 0) {
            this.vanillaPartialFace(quad, (flags & 4) != 0);
        } else {
            this.vanillaFullFace(quad, (flags & 4) != 0);
        }
    }

    private void calcEnhanced(MutableQuadViewImpl quad) {
        switch (quad.geometryFlags()) {
            case 6: 
            case 7: {
                this.vanillaPartialFace(quad, true);
                break;
            }
            case 2: 
            case 3: {
                this.blendedPartialFace(quad);
                break;
            }
            default: {
                this.irregularFace(quad);
            }
        }
    }

    private void vanillaFullFace(QuadViewImpl quad, boolean isOnLightFace) {
        Direction lightFace = quad.lightFace();
        this.computeFace(lightFace, isOnLightFace, quad.hasShade()).toArray(this.ao, this.light, VERTEX_MAP[lightFace.m_122411_()]);
    }

    private void vanillaPartialFace(QuadViewImpl quad, boolean isOnLightFace) {
        Direction lightFace = quad.lightFace();
        AoFaceData faceData = this.computeFace(lightFace, isOnLightFace, quad.hasShade());
        AoFace.WeightFunction wFunc = AoFace.get((Direction)lightFace).weightFunc;
        float[] w = this.w;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, w);
            this.light[i] = faceData.weightedCombinedLight(w);
            this.ao[i] = faceData.weigtedAo(w);
        }
    }

    private AoFaceData blendedInsetFace(QuadViewImpl quad, int vertexIndex, Direction lightFace) {
        float w1 = AoFace.get((Direction)lightFace).depthFunc.apply(quad, vertexIndex);
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, quad.hasShade()), w0, this.computeFace(lightFace, false, quad.hasShade()), w1, this.tmpFace);
    }

    private AoFaceData gatherInsetFace(QuadViewImpl quad, int vertexIndex, Direction lightFace) {
        float w1 = AoFace.get((Direction)lightFace).depthFunc.apply(quad, vertexIndex);
        if (Mth.m_14033_((float)w1, (float)0.0f)) {
            return this.computeFace(lightFace, true, quad.hasShade());
        }
        if (Mth.m_14033_((float)w1, (float)1.0f)) {
            return this.computeFace(lightFace, false, quad.hasShade());
        }
        float w0 = 1.0f - w1;
        return AoFaceData.weightedMean(this.computeFace(lightFace, true, quad.hasShade()), w0, this.computeFace(lightFace, false, quad.hasShade()), w1, this.tmpFace);
    }

    private void blendedPartialFace(QuadViewImpl quad) {
        Direction lightFace = quad.lightFace();
        AoFaceData faceData = this.blendedInsetFace(quad, 0, lightFace);
        AoFace.WeightFunction wFunc = AoFace.get((Direction)lightFace).weightFunc;
        for (int i = 0; i < 4; ++i) {
            wFunc.apply(quad, i, this.w);
            this.light[i] = faceData.weightedCombinedLight(this.w);
            this.ao[i] = faceData.weigtedAo(this.w);
        }
    }

    private void irregularFace(MutableQuadViewImpl quad) {
        Vector3f faceNorm = quad.faceNormal();
        float[] w = this.w;
        float[] aoResult = this.ao;
        int[] lightResult = this.light;
        for (int i = 0; i < 4; ++i) {
            float z;
            float y;
            Vector3f normal = quad.hasNormal(i) ? quad.copyNormal(i, this.vertexNormal) : faceNorm;
            float ao = 0.0f;
            float sky = 0.0f;
            float block = 0.0f;
            float maxAo = 0.0f;
            int maxSky = 0;
            int maxBlock = 0;
            float x = normal.m_122239_();
            if (!Mth.m_14033_((float)0.0f, (float)x)) {
                Direction face = x > 0.0f ? Direction.EAST : Direction.WEST;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = x * x;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = a;
                maxSky = s;
                maxBlock = b;
            }
            if (!Mth.m_14033_((float)0.0f, (float)(y = normal.m_122260_()))) {
                Direction face = y > 0.0f ? Direction.UP : Direction.DOWN;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = y * y;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            if (!Mth.m_14033_((float)0.0f, (float)(z = normal.m_122269_()))) {
                Direction face = z > 0.0f ? Direction.SOUTH : Direction.NORTH;
                AoFaceData fd = this.gatherInsetFace(quad, i, face);
                AoFace.get((Direction)face).weightFunc.apply(quad, i, w);
                float n = z * z;
                float a = fd.weigtedAo(w);
                int s = fd.weigtedSkyLight(w);
                int b = fd.weigtedBlockLight(w);
                ao += n * a;
                sky += n * (float)s;
                block += n * (float)b;
                maxAo = Math.max(maxAo, a);
                maxSky = Math.max(maxSky, s);
                maxBlock = Math.max(maxBlock, b);
            }
            aoResult[i] = (ao + maxAo) * 0.5f;
            lightResult[i] = ((int)((sky + (float)maxSky) * 0.5f) & 0xF0) << 16 | (int)((block + (float)maxBlock) * 0.5f) & 0xF0;
        }
    }

    private AoFaceData computeFace(Direction lightFace, boolean isOnBlockFace, boolean shade) {
        int faceDataIndex = isOnBlockFace ? lightFace.m_122411_() : lightFace.m_122411_() + 6;
        int mask = 1 << faceDataIndex;
        AoFaceData result = this.faceData[faceDataIndex];
        if ((this.completionFlags & mask) == 0) {
            int cLight3;
            float cAo3;
            int cLight2;
            float cAo2;
            int cLight1;
            float cAo1;
            int cLight0;
            float cAo0;
            int lightPosZ;
            int lightPosY;
            int lightPosX;
            this.completionFlags |= mask;
            LightDataAccess cache = this.lightCache;
            BlockPos pos = this.blockInfo.blockPos;
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (isOnBlockFace) {
                lightPosX = x + lightFace.m_122429_();
                lightPosY = y + lightFace.m_122430_();
                lightPosZ = z + lightFace.m_122431_();
            } else {
                lightPosX = x;
                lightPosY = y;
                lightPosZ = z;
            }
            AoFace aoFace = AoFace.get(lightFace);
            Direction[] neighbors = aoFace.neighbors;
            long word0 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[0]);
            int light0 = LightDataAccess.unpackLM((long)word0);
            float ao0 = LightDataAccess.unpackAO((long)word0);
            boolean isClear0 = LightDataAccess.unpackOP((long)word0);
            long word1 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[1]);
            int light1 = LightDataAccess.unpackLM((long)word1);
            float ao1 = LightDataAccess.unpackAO((long)word1);
            boolean isClear1 = LightDataAccess.unpackOP((long)word1);
            long word2 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[2]);
            int light2 = LightDataAccess.unpackLM((long)word2);
            float ao2 = LightDataAccess.unpackAO((long)word2);
            boolean isClear2 = LightDataAccess.unpackOP((long)word2);
            long word3 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[3]);
            int light3 = LightDataAccess.unpackLM((long)word3);
            float ao3 = LightDataAccess.unpackAO((long)word3);
            boolean isClear3 = LightDataAccess.unpackOP((long)word3);
            if (!isClear2 && !isClear0) {
                cAo0 = ao0;
                cLight0 = light0;
            } else {
                long word02 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[0], neighbors[2]);
                cAo0 = LightDataAccess.unpackAO((long)word02);
                cLight0 = LightDataAccess.unpackLM((long)word02);
            }
            if (!isClear3 && !isClear0) {
                cAo1 = ao0;
                cLight1 = light0;
            } else {
                long word03 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[0], neighbors[3]);
                cAo1 = LightDataAccess.unpackAO((long)word03);
                cLight1 = LightDataAccess.unpackLM((long)word03);
            }
            if (!isClear2 && !isClear1) {
                cAo2 = ao1;
                cLight2 = light1;
            } else {
                long word12 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[1], neighbors[2]);
                cAo2 = LightDataAccess.unpackAO((long)word12);
                cLight2 = LightDataAccess.unpackLM((long)word12);
            }
            if (!isClear3 && !isClear1) {
                cAo3 = ao1;
                cLight3 = light1;
            } else {
                long word13 = cache.get(lightPosX, lightPosY, lightPosZ, neighbors[1], neighbors[3]);
                cAo3 = LightDataAccess.unpackAO((long)word13);
                cLight3 = LightDataAccess.unpackLM((long)word13);
            }
            long centerWord = cache.get(lightPosX, lightPosY, lightPosZ);
            int lightCenter = isOnBlockFace || !LightDataAccess.unpackFO((long)centerWord) ? LightDataAccess.unpackLM((long)centerWord) : LightDataAccess.unpackLM((long)cache.get(x, y, z));
            float aoCenter = LightDataAccess.unpackAO((long)centerWord);
            float worldBrightness = this.blockInfo.blockView.m_7717_(lightFace, shade);
            result.a0 = (ao3 + ao0 + cAo1 + aoCenter) * 0.25f * worldBrightness;
            result.a1 = (ao2 + ao0 + cAo0 + aoCenter) * 0.25f * worldBrightness;
            result.a2 = (ao2 + ao1 + cAo2 + aoCenter) * 0.25f * worldBrightness;
            result.a3 = (ao3 + ao1 + cAo3 + aoCenter) * 0.25f * worldBrightness;
            result.l0(AoCalculator.meanBrightness(light3, light0, cLight1, lightCenter));
            result.l1(AoCalculator.meanBrightness(light2, light0, cLight0, lightCenter));
            result.l2(AoCalculator.meanBrightness(light2, light1, cLight2, lightCenter));
            result.l3(AoCalculator.meanBrightness(light3, light1, cLight3, lightCenter));
        }
        return result;
    }

    private static int meanBrightness(int a, int b, int c, int d) {
        return a == 0 || b == 0 || c == 0 || d == 0 ? AoCalculator.meanEdgeBrightness(a, b, c, d) : AoCalculator.meanInnerBrightness(a, b, c, d);
    }

    private static int meanInnerBrightness(int a, int b, int c, int d) {
        return a + b + c + d >> 2 & 0xFF00FF;
    }

    private static int nonZeroMin(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        return Math.min(a, b);
    }

    private static int meanEdgeBrightness(int a, int b, int c, int d) {
        int min = AoCalculator.nonZeroMin(AoCalculator.nonZeroMin(a, b), AoCalculator.nonZeroMin(c, d));
        return AoCalculator.meanInnerBrightness(Math.max(a, min), Math.max(b, min), Math.max(c, min), Math.max(d, min));
    }

    static {
        AoCalculator.VERTEX_MAP[Direction.DOWN.m_122411_()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[Direction.UP.m_122411_()] = new int[]{2, 3, 0, 1};
        AoCalculator.VERTEX_MAP[Direction.NORTH.m_122411_()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[Direction.SOUTH.m_122411_()] = new int[]{0, 1, 2, 3};
        AoCalculator.VERTEX_MAP[Direction.WEST.m_122411_()] = new int[]{3, 0, 1, 2};
        AoCalculator.VERTEX_MAP[Direction.EAST.m_122411_()] = new int[]{1, 2, 3, 0};
    }
}

