/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.mixin.sodium;

import link.infra.indium.Indium;
import link.infra.indium.renderer.render.TerrainRenderContext;
import me.jellysquid.mods.sodium.client.gl.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildResult;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderBuildTask;
import me.jellysquid.mods.sodium.client.render.chunk.tasks.ChunkRenderRebuildTask;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.util.task.CancellationSource;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkRenderRebuildTask.class})
public abstract class MixinChunkRenderRebuildTask
extends ChunkRenderBuildTask {
    @Inject(method={"performBuild"}, at={@At(value="HEAD")}, remap=false)
    public void beforePerformBuild(ChunkBuildContext buildContext, CancellationSource cancellationSource, CallbackInfoReturnable<ChunkBuildResult> cir) {
        TerrainRenderContext.get(buildContext).prepare(buildContext);
    }

    @Inject(method={"performBuild"}, at={@At(value="RETURN")}, remap=false)
    public void afterPerformBuild(ChunkBuildContext buildContext, CancellationSource cancellationSource, CallbackInfoReturnable<ChunkBuildResult> cir) {
        TerrainRenderContext.get(buildContext).release();
    }

    @Redirect(method={"performBuild"}, at=@At(value="INVOKE", target="Lme/jellysquid/mods/sodium/client/render/pipeline/BlockRenderer;renderModel(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/client/render/model/BakedModel;Lme/jellysquid/mods/sodium/client/render/chunk/compile/buffers/ChunkModelBuilder;ZJLnet/minecraftforge/client/model/data/ModelData;Lnet/minecraft/client/render/RenderLayer;Lnet/minecraft/util/math/random/Random;)Z"))
    public boolean onRenderBlock(BlockRenderer blockRenderer, BlockAndTintGetter world, BlockState state, BlockPos pos, BlockPos origin, BakedModel model, ChunkModelBuilder buffers, boolean cull, long seed, ModelData modelData, RenderType layer, RandomSource random, ChunkBuildContext buildContext, CancellationSource cancellationSource) {
        if (!Indium.ALWAYS_TESSELLATE_INDIUM && ((FabricBakedModel)model).isVanillaAdapter()) {
            return blockRenderer.renderModel(world, state, pos, origin, model, buffers, cull, seed, modelData, layer, random);
        }
        Vec3 modelOffset = state.m_60824_((BlockGetter)world, pos);
        return TerrainRenderContext.get(buildContext).tessellateBlock((BlockGetter)world, state, pos, origin, model, modelOffset, modelData, layer);
    }
}

