/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.redirector;

import com.teampotato.redirector.Redirector;
import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.EnumSet;
import java.util.ListIterator;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class RedirectorLaunchPluginService
implements ILaunchPluginService {
    public String name() {
        return "redirector";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        return EnumSet.of(ILaunchPluginService.Phase.AFTER);
    }

    public boolean processClass(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if (phase == ILaunchPluginService.Phase.BEFORE) {
            return false;
        }
        if ("classloading".equals(reason)) {
            String name = classNode.name;
            if ("java/lang/Enum".equals(classNode.superName)) {
                for (MethodNode methodNode : classNode.methods) {
                    if (!"values".equals(methodNode.name) || !methodNode.desc.contains("()")) continue;
                    InsnList insnNodes = methodNode.instructions;
                    ListIterator iterator = insnNodes.iterator();
                    AbstractInsnNode n1 = null;
                    AbstractInsnNode n2 = null;
                    while (iterator.hasNext()) {
                        AbstractInsnNode node = (AbstractInsnNode)iterator.next();
                        if (178 == node.getOpcode()) {
                            n1 = node;
                            continue;
                        }
                        if (176 != node.getOpcode()) continue;
                        n2 = node;
                    }
                    insnNodes.clear();
                    insnNodes.add(n1);
                    insnNodes.add(n2);
                    Redirector.LOGGER.info("Redirecting " + name);
                    return true;
                }
            }
        }
        return false;
    }
}

