/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier;

import com.builtbroken.ai.improvements.ConfigMain;
import com.builtbroken.ai.improvements.FixedLookControl;
import com.builtbroken.ai.improvements.modifier.ModifierLevel;
import com.builtbroken.ai.improvements.modifier.editor.FilteredRemove;
import com.builtbroken.ai.improvements.modifier.editor.GenericRemove;
import com.builtbroken.ai.improvements.modifier.filters.FilterLayer;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowFlockLeaderGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Squid;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="aiimprovements")
public class ModifierSystem {
    public static final FilterLayer editor = new FilterLayer(null);
    public static final ModifierLevel mobEntityEditor = ModifierLevel.newFilter(entity -> entity instanceof Mob);
    public static final ModifierLevel fishEditor = ModifierLevel.newFilter(entity -> entity instanceof AbstractFish);
    public static final ModifierLevel squidEditor = ModifierLevel.newFilter(entity -> entity instanceof Squid);
    public static final ModifierLevel cowEditor = ModifierLevel.newFilter(entity -> entity instanceof Cow);
    public static final ModifierLevel chickenEditor = ModifierLevel.newFilter(entity -> entity instanceof Chicken);
    public static final ModifierLevel pigEditor = ModifierLevel.newFilter(entity -> entity instanceof Pig);
    public static final ModifierLevel sheepEditor = ModifierLevel.newFilter(entity -> entity instanceof Sheep);

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        editor.handle(event.getEntity());
    }

    public static void init() {
        editor.add(mobEntityEditor);
        ModifierSystem.mobEntityEditor.goalEditor.add(new FilteredRemove(goal -> goal instanceof LookAtPlayerGoal, ConfigMain.CONFIG.removeLookGoal));
        ModifierSystem.mobEntityEditor.goalEditor.add(new FilteredRemove(goal -> goal instanceof RandomLookAroundGoal, ConfigMain.CONFIG.removeLookRandom));
        ModifierSystem.mobEntityEditor.filters.add(entity -> ModifierSystem.replaceLookHelper((Mob)entity));
        ModifierSystem.mobEntityEditor.filters.add(fishEditor);
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof RandomSwimmingGoal, ConfigMain.CONFIG.removeFishSwim));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof AvoidEntityGoal, ConfigMain.CONFIG.removeFishAvoidPlayer));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PanicGoal, ConfigMain.CONFIG.removeFishPanic));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FollowFlockLeaderGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.fishEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof Pufferfish.PufferfishPuffGoal, ConfigMain.CONFIG.removeFishFollowLeader));
        ModifierSystem.mobEntityEditor.filters.add(squidEditor);
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof Squid.SquidRandomMovementGoal, ConfigMain.CONFIG.removeRandomMove));
        ModifierSystem.squidEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof Squid.SquidFleeGoal, ConfigMain.CONFIG.removeRandomMove));
        ModifierSystem.mobEntityEditor.filters.add(cowEditor);
        ModifierSystem.populateAnimalEditor(cowEditor, ConfigMain.CONFIG.cow);
        ModifierSystem.mobEntityEditor.filters.add(chickenEditor);
        ModifierSystem.populateAnimalEditor(chickenEditor, ConfigMain.CONFIG.chicken);
        ModifierSystem.mobEntityEditor.filters.add(pigEditor);
        ModifierSystem.populateAnimalEditor(pigEditor, ConfigMain.CONFIG.pig);
        ModifierSystem.mobEntityEditor.filters.add(sheepEditor);
        ModifierSystem.populateAnimalEditor(sheepEditor, ConfigMain.CONFIG.sheep);
        ModifierSystem.sheepEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof EatBlockGoal, ConfigMain.CONFIG.removeSheepEatBlock));
    }

    private static FilterResult replaceLookHelper(Mob living) {
        ConfigMain.FilteredConfigValue replaceLookController = ConfigMain.CONFIG.replaceLookController;
        if (((Boolean)replaceLookController.configValue().get()).booleanValue() && (living.m_21563_() == null || living.m_21563_().getClass() == LookControl.class)) {
            if (replaceLookController.isFiltered(ForgeRegistries.ENTITY_TYPES.getKey((Object)living.m_6095_()).toString())) {
                return FilterResult.DID_NOTHING;
            }
            LookControl oldHelper = living.m_21563_();
            living.f_21365_ = new FixedLookControl(living);
            LookControl lookControl = living.m_21563_();
            if (lookControl instanceof FixedLookControl) {
                FixedLookControl flc = (FixedLookControl)lookControl;
                flc.copyDataIntoSelf(oldHelper);
                return FilterResult.MODIFIED;
            }
        }
        return FilterResult.DID_NOTHING;
    }

    private static void populateAnimalEditor(ModifierLevel animalEditor, ConfigMain.AnimalConfigSection configs) {
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FloatGoal, configs.removeFloat()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof PanicGoal, configs.removePanic()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof BreedGoal, configs.removeBreed()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof TemptGoal, configs.removeTempt()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof FollowParentGoal, configs.removeFollowParent()));
        animalEditor.goalEditor.add(new GenericRemove(goal -> goal instanceof WaterAvoidingRandomStrollGoal, configs.removeStroll()));
    }
}

