/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.ecostackmanager.config;

import de.markusbordihn.ecostackmanager.config.Config;
import java.io.File;
import java.util.Properties;
import java.util.Set;

public class ItemEntityConfig
extends Config {
    public static final String CONFIG_FILE_NAME = "item_entity.cfg";
    public static final String CONFIG_FILE_HEADER = "Item Entity Configuration";
    public static Set<String> allowList = Set.of();
    public static Set<String> denyList = Set.of("minecraft:diamond", "minecraft:diamond_block");
    public static int collectRadius = 3;
    public static int maxNumberOfItemsPerWorld = 128;
    public static int maxNumberOfItemsPerType = 32;
    public static int maxStackSize = 64;
    public static boolean movePositionToLastDrop = false;
    public static int verificationCycle = 64;

    public static void registerConfig() {
        ItemEntityConfig.registerConfigFile(CONFIG_FILE_NAME, CONFIG_FILE_HEADER);
        ItemEntityConfig.parseConfigFile();
    }

    public static void parseConfigFile() {
        File configFile = ItemEntityConfig.getConfigFile(CONFIG_FILE_NAME);
        Properties properties = ItemEntityConfig.readConfigFile(configFile);
        Properties unmodifiedProperties = (Properties)properties.clone();
        allowList = ItemEntityConfig.parseConfigValue(properties, "allow_list", allowList);
        denyList = ItemEntityConfig.parseConfigValue(properties, "deny_list", denyList);
        collectRadius = ItemEntityConfig.parseConfigValue(properties, "collect_radius", collectRadius);
        maxNumberOfItemsPerWorld = ItemEntityConfig.parseConfigValue(properties, "max_number_of_items_per_world", maxNumberOfItemsPerWorld);
        maxNumberOfItemsPerType = ItemEntityConfig.parseConfigValue(properties, "max_number_of_items_per_type", maxNumberOfItemsPerType);
        maxStackSize = ItemEntityConfig.parseConfigValue(properties, "max_stack_size", maxStackSize);
        movePositionToLastDrop = ItemEntityConfig.parseConfigValue(properties, "move_position_to_last_drop", movePositionToLastDrop);
        verificationCycle = ItemEntityConfig.parseConfigValue(properties, "verification_cycle", verificationCycle);
        ItemEntityConfig.updateConfigFileIfChanged(configFile, CONFIG_FILE_HEADER, properties, unmodifiedProperties);
    }
}

