/*
 * Decompiled with CFR 0.152.
 */
package absolem.fixmyspawnr.mixin;

import absolem.fixmyspawnr.CommonConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class StopServerLogicIfPowered {
    private int blockExistsTick = 0;
    private boolean blockLockedByTime = false;

    @Inject(at={@At(value="HEAD")}, method={"serverTick"}, cancellable=true)
    public void stopLogicIfPowered(ServerLevel level, BlockPos pos, CallbackInfo ci) {
        if (!this.blockLockedByTime) {
            if (this.blockExistsTick > CommonConfig.timer_time_out) {
                this.blockLockedByTime = true;
            } else {
                ++this.blockExistsTick;
            }
        }
        int signal = level.m_46755_(pos);
        if (this.blockLockedByTime && signal > 0) {
            ci.cancel();
            return;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"save"})
    public void addTickToSave(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        tag.m_128405_("fixmyspawnrTicks", this.blockExistsTick);
        tag.m_128379_("fixMySpawnerLocked", this.blockLockedByTime);
    }

    @Inject(at={@At(value="TAIL")}, method={"load"})
    public void loadTickFromSave(Level level, BlockPos pos, CompoundTag tag, CallbackInfo ci) {
        this.blockExistsTick = tag.m_128451_("fixmyspawnrTicks");
        this.blockLockedByTime = tag.m_128471_("fixMySpawnerLocked");
    }
}

