/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.fastpaintings;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import net.mehvahdjukaar.fastpaintings.DropMode;
import net.mehvahdjukaar.fastpaintings.PaintingBlock;
import net.mehvahdjukaar.fastpaintings.PaintingBlockEntity;
import net.mehvahdjukaar.fastpaintings.SetPaintingMessage;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class FastPaintings {
    public static final String MOD_ID = "fastpaintings";
    public static Supplier<DropMode> SPECIAL_DROP;
    public static final ChannelHandler CHANNEL;
    public static SoundType PAINTING;
    public static final Supplier<Block> PAINTING_BLOCK;
    public static final Supplier<BlockEntityType<PaintingBlockEntity>> PAINTING_TILE;
    public static final LoadingCache<Integer, BlockPos> LAST_KNOWN_ENTITY_POS;

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void init() {
        CHANNEL.register(NetworkDir.PLAY_TO_SERVER, SetPaintingMessage.class, SetPaintingMessage::new);
        ConfigBuilder builder = ConfigBuilder.create((String)MOD_ID, (ConfigType)ConfigType.COMMON);
        builder.push("general");
        SPECIAL_DROP = builder.comment("Makes paintings always drop with their NBT").define("nbt_drop", (Enum)DropMode.OFF);
        builder.pop();
        builder.buildAndRegister();
    }

    static {
        CHANNEL = ChannelHandler.createChannel((ResourceLocation)FastPaintings.res("channel"));
        PAINTING = new SoundType(1.0f, 1.0f, SoundEvents.f_12175_, SoundEvents.f_11992_, SoundEvents.f_12176_, SoundEvents.f_12634_, SoundEvents.f_12633_);
        PAINTING_BLOCK = RegHelper.registerBlock((ResourceLocation)FastPaintings.res("painting"), () -> new PaintingBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_164532_).m_155949_(MaterialColor.f_76398_).m_60966_().m_60918_(PAINTING)));
        PAINTING_TILE = RegHelper.registerBlockEntityType((ResourceLocation)FastPaintings.res("painting"), () -> PlatformHelper.newBlockEntityType(PaintingBlockEntity::new, (Block[])new Block[]{PAINTING_BLOCK.get()}));
        LAST_KNOWN_ENTITY_POS = CacheBuilder.newBuilder().expireAfterAccess(Duration.of(5L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<Integer, BlockPos>(){

            public BlockPos load(Integer key) {
                return null;
            }
        });
    }
}

