/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.letmedespawn.command;

import com.frikinjay.letmedespawn.LetMeDespawn;
import com.frikinjay.letmedespawn.config.LetMeDespawnConfig;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;

public class LetMeDespawnCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lmd").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(LetMeDespawnCommands::reloadConfig))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> {
            Registry.f_122826_.forEach(entityType -> {
                if (entityType.m_20674_().equals((Object)MobCategory.MONSTER)) {
                    builder.suggest(Registry.f_122826_.m_7981_(entityType).toString());
                }
            });
            return builder.buildFuture();
        }).executes(LetMeDespawnCommands::addMob)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"mobName", (ArgumentType)StringArgumentType.greedyString()).suggests(LetMeDespawnCommands::suggestMobNames).executes(LetMeDespawnCommands::removeMob))));
    }

    private static CompletableFuture<Suggestions> suggestMobNames(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        LetMeDespawnConfig config = LetMeDespawn.config;
        config.getMobNames().stream().filter(mobName -> mobName.startsWith(builder.getRemaining())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        LetMeDespawn.config = LetMeDespawnConfig.load();
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)"LetMeDespawn configuration reloaded!").m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static int addMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Mob '" + mobName + "' is already in the configuration.")).m_130940_(ChatFormatting.RED), false);
        } else {
            LetMeDespawn.config.addMobName(mobName);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Added '" + mobName + "' to LetMeDespawn configuration.")).m_130940_(ChatFormatting.AQUA), true);
        }
        return 1;
    }

    private static int removeMob(CommandContext<CommandSourceStack> context) {
        String mobName = StringArgumentType.getString(context, (String)"mobName");
        if (LetMeDespawn.config.getMobNames().contains(mobName)) {
            LetMeDespawn.config.removeMobName(mobName);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Removed '" + mobName + "' from LetMeDespawn configuration.")).m_130940_(ChatFormatting.GOLD), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("Mob '" + mobName + "' is not in the configuration.")).m_130940_(ChatFormatting.RED), false);
        }
        return 1;
    }
}

