/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Properties;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class VariantProperty
extends StringArrayOrRegexProperty {
    private final boolean doPrint;

    protected VariantProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string.replace("print:", ""));
        this.doPrint = string.startsWith("print:");
    }

    public static VariantProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new VariantProperty(VariantProperty.readPropertiesOrThrow(properties, propertyNum, "variant", "variants"));
        }
        catch (RandomProperty.RandomPropertyException var3) {
            return null;
        }
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Override
    @Nullable
    protected String getValueFromEntity(ETFEntity etfEntity) {
        String value = this.getValueFromEntityInternal(etfEntity);
        if (this.doPrint) {
            ETFUtils2.logMessage("[variant property print] = " + (value == null ? "//VARIANT CHECK FAILED AND WILL RETURN FALSE//" : value));
        }
        return value;
    }

    @Nullable
    private String getValueFromEntityInternal(ETFEntity etfEntity) {
        if (etfEntity instanceof Entity) {
            if (etfEntity instanceof Cat) {
                Cat catEntity = (Cat)etfEntity;
                return catEntity.m_218139_().toString();
            }
            if (etfEntity instanceof Frog) {
                Frog frogEntity = (Frog)etfEntity;
                return frogEntity.m_218524_().toString();
            }
            if (etfEntity instanceof Painting) {
                Painting paintingEntity = (Painting)etfEntity;
                return paintingEntity.m_218901_().toString();
            }
            if (etfEntity instanceof Shulker) {
                Shulker shulker = (Shulker)etfEntity;
                if (shulker.m_33467_() == null) {
                    return null;
                }
                return shulker.m_33467_().toString();
            }
            if (etfEntity instanceof Villager) {
                Villager villagerType = (Villager)etfEntity;
                return villagerType.m_7141_().m_35560_().toString();
            }
            return Registry.f_122826_.m_7854_((Object)((Entity)etfEntity).m_6095_()).map(key -> key.m_135782_().m_135815_()).orElse(null);
        }
        if (etfEntity instanceof BlockEntity) {
            BedBlockEntity bedBlockEntity;
            ShulkerBoxBlockEntity shulkerBoxBlockEntity;
            SignBlockEntity signBlockEntity;
            Block block;
            if (etfEntity instanceof SignBlockEntity && (block = (signBlockEntity = (SignBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof SignBlock) {
                SignBlock abstractSignBlock = (SignBlock)block;
                return abstractSignBlock.m_56297_().m_61846_();
            }
            if (etfEntity instanceof ShulkerBoxBlockEntity && (block = (shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock shulkerBoxBlock = (ShulkerBoxBlock)block;
                return String.valueOf(shulkerBoxBlock.m_56261_());
            }
            if (etfEntity instanceof BedBlockEntity && (block = (bedBlockEntity = (BedBlockEntity)etfEntity).m_58900_().m_60734_()) instanceof BedBlock) {
                BedBlock bedBlock = (BedBlock)block;
                return String.valueOf(bedBlock.m_49554_());
            }
            Object suffix = "";
            if (etfEntity instanceof SkullBlockEntity) {
                SkullBlockEntity skull = (SkullBlockEntity)etfEntity;
                suffix = "_direction_" + ((Integer)skull.m_58900_().m_61143_((Property)SkullBlock.f_56314_)).toString();
            }
            return (String)Registry.f_122830_.m_7854_((Object)((BlockEntity)etfEntity).m_58903_()).map(key -> key.m_135782_().m_135815_()).orElse(null) + (String)suffix;
        }
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"variant", "variants"};
    }
}

