/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.etf_properties;

import java.util.Properties;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class DimensionProperty
extends StringArrayOrRegexProperty {
    private final boolean doPrint;

    protected DimensionProperty(String string) throws RandomProperty.RandomPropertyException {
        super(string.replace("print:", ""));
        this.doPrint = string.startsWith("print:");
    }

    public static DimensionProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new DimensionProperty(RandomProperty.readPropertiesOrThrow(properties, propertyNum, "dimension"));
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public String getValueFromEntity(ETFEntity etfEntity) {
        if (etfEntity == null) {
            return null;
        }
        Level world = etfEntity.etf$getWorld();
        if (world == null) {
            return null;
        }
        ResourceKey dimKey = etfEntity.etf$getWorld().m_220362_();
        if (dimKey == null) {
            return null;
        }
        ResourceLocation key = dimKey.m_135782_();
        if (key == null) {
            return null;
        }
        String output = key.equals((Object)BuiltinDimensionTypes.f_223542_) || key.m_135815_().equals("overworld_caves") ? "overworld" : (key.equals((Object)BuiltinDimensionTypes.f_223543_) ? "the_nether" : (key.equals((Object)BuiltinDimensionTypes.f_223544_) ? "the_end" : key.toString()));
        if (this.doPrint) {
            ETFUtils2.logMessage("[Dimension property print]: " + output);
        }
        return output;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"dimension"};
    }

    @Override
    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }
}

