/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.data.models;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.core.data.ValhelsiaBlockStateProvider;
import net.valhelsia.valhelsia_furniture.ValhelsiaFurniture;
import net.valhelsia.valhelsia_furniture.common.block.ChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.StoolBlock;
import net.valhelsia.valhelsia_furniture.common.block.TableBlock;
import net.valhelsia.valhelsia_furniture.common.block.UpholsteredChairBlock;
import net.valhelsia.valhelsia_furniture.common.block.properties.ClosedCurtainPart;
import net.valhelsia.valhelsia_furniture.common.block.properties.ModBlockStateProperties;
import net.valhelsia.valhelsia_furniture.common.block.properties.OpenCurtainPart;
import net.valhelsia.valhelsia_furniture.common.util.TextureKey;
import net.valhelsia.valhelsia_furniture.core.registry.ModBlocks;

public class ModBlockStateProvider
extends ValhelsiaBlockStateProvider {
    public ModBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, ValhelsiaFurniture.REGISTRY_MANAGER, exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.forEach(block -> block instanceof TableBlock, block -> this.tableBlock((TableBlock)((Object)block)));
        this.forEach(block -> block instanceof UpholsteredChairBlock, block -> this.horizontalBlock((Block)block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block), this.modLoc("block/template_upholstered_chair"))).texture("wool", this.modLoc("block/upholstered_chair/colors/" + ((ChairBlock)block).getColor()))).texture("wood", this.modLoc("block/upholstered_chair/base/" + ((ChairBlock)block).getBaseName()))));
        this.forEach(block -> block instanceof ChairBlock, block -> this.horizontalBlock((Block)block, (ModelFile)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block), this.modLoc("block/template_chair"))).texture("chair", this.modLoc("block/chair/" + ((ChairBlock)block).getBaseName() + "/" + this.getName((Block)block)))));
        this.forEach(block -> block instanceof StoolBlock, block -> this.stoolBlock((StoolBlock)block));
        this.forEach(block -> block instanceof DeskBlock, block -> this.desk((DeskBlock)((Object)block)));
        ModBlocks.FABRIC_DESK_LAMPS.forEach((color, registryObject) -> this.take(block -> {
            ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block), this.modLoc("block/template_fabric_desk_lamp"))).texture("color", this.modLoc("block/fabric_desk_lamp/colors/" + color));
            ModelBuilder modelOn = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_on", this.modLoc("block/template_fabric_desk_lamp_on"))).texture("color", this.modLoc("block/fabric_desk_lamp/colors/" + color));
            this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$registerStatesAndModels$10((ModelFile)modelOn, (ModelFile)model, arg_0), new Property[]{BlockStateProperties.f_61362_, BlockStateProperties.f_61448_});
        }, new RegistryObject[]{registryObject}));
        ModBlocks.CURTAINS.forEach((color, pair) -> {
            this.take(block -> this.horizontalBlock((Block)block, state -> {
                ClosedCurtainPart part = (ClosedCurtainPart)((Object)state.m_61143_(ModBlockStateProperties.CLOSED_CURTAIN_PART));
                return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + part.getModelName(), part.getParentModel())).texture("top", this.modLoc("block/curtain/" + color + "/" + part.getTopTexture()))).texture("down", this.modLoc("block/curtain/" + color + "/" + part.getBottomTexture()))).renderType("cutout");
            }), new RegistryObject[]{(RegistryObject)pair.getFirst()});
            this.take(block -> this.horizontalBlock((Block)block, state -> {
                OpenCurtainPart part = (OpenCurtainPart)((Object)state.m_61143_(ModBlockStateProperties.OPEN_CURTAIN_PART));
                if (part == OpenCurtainPart.TOP) {
                    return this.models().getExistingFile(this.modLoc("block/curtain/curtain_bracket"));
                }
                return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + part.getModelName() + "_open", part.getParentModel())).texture("top", this.modLoc("block/curtain/" + color + "/" + part.getTopTexture()))).texture("down", this.modLoc("block/curtain/" + color + "/" + part.getBottomTexture()))).renderType("cutout");
            }), new RegistryObject[]{(RegistryObject)pair.getSecond()});
        });
    }

    public void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, int angleOffset) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + angleOffset) % 360).build(), new Property[]{BlockStateProperties.f_61362_, BlockStateProperties.f_61448_});
    }

    private void desk(DeskBlock block) {
        this.horizontalBlock(block, state -> {
            boolean left = (Boolean)state.m_61143_((Property)ModBlockStateProperties.LEFT);
            boolean right = (Boolean)state.m_61143_((Property)ModBlockStateProperties.RIGHT);
            String variant = "";
            if (left && right) {
                variant = "_center";
            } else if (left) {
                variant = "_right";
            } else if (right) {
                variant = "_left";
            }
            String name = this.getName(block);
            boolean drawer = false;
            if (name.contains("drawer")) {
                name = name.substring(0, name.length() - 7);
                drawer = true;
            }
            name = name.substring(0, name.length() - 5);
            List<TextureKey> keys = variant.equals("_left") || variant.equals("_right") ? DeskBlock.VARIANT_TEXTURES.get("left_or_right") : (variant.equals("_center") ? DeskBlock.VARIANT_TEXTURES.get("center") : DeskBlock.VARIANT_TEXTURES.get("single"));
            return this.addTextures((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + variant, this.modLoc("block/desk/template_desk" + (drawer ? "_drawer" : "") + variant)), keys, name);
        });
    }

    private BlockModelBuilder addTextures(BlockModelBuilder builder, List<TextureKey> textureKeys, String type) {
        for (TextureKey key : textureKeys) {
            builder.texture(key.key(), key.apply(type));
        }
        return builder;
    }

    private void tableBlock(TableBlock block) {
        String name = this.getName(block);
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            String s;
            boolean north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
            boolean east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
            boolean south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
            boolean west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
            boolean rotated = (Boolean)state.m_61143_((Property)ModBlockStateProperties.ROTATED);
            boolean connected = north || east || south || west;
            boolean allConnected = north && east && south && west;
            String string = s = connected ? "_" : "";
            if (north) {
                String string2 = s = rotated && !allConnected ? s.concat("e") : s.concat("n");
            }
            if (east) {
                String string3 = s = rotated && !allConnected ? s.concat("s") : s.concat("e");
            }
            if (south) {
                String string4 = s = rotated && !allConnected ? s.concat("w") : s.concat("s");
            }
            if (west) {
                s = rotated && !allConnected ? s.concat("n") : s.concat("w");
            }
            s = switch (s) {
                case "_esn" -> "_nes";
                case "_swn" -> "_nsw";
                case "_ewn" -> "_new";
                case "_sn" -> "_ns";
                case "_en" -> "_ne";
                case "_wn" -> "_nw";
                default -> s;
            };
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name + s, this.modLoc("block/template_table" + s))).texture("table", this.modLoc("block/" + block.getBaseName() + "/" + name))).texture("connected_table", this.modLoc("block/" + block.getBaseName() + "/" + name + "_connected"));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(!connected && rotated ? 90 : (rotated ? 270 : 0)).build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void stoolBlock(StoolBlock block) {
        ModelBuilder rotatedModel;
        ModelBuilder model;
        if (block.getColor() != null) {
            model = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.modLoc("block/template_upholstered_stool"))).texture("wood", this.modLoc("block/upholstered_stool/base/" + block.getBaseName()))).texture("wool", this.modLoc("block/upholstered_stool/colors/" + block.getColor()));
            rotatedModel = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_rotated", this.modLoc("block/template_upholstered_stool_rotated"))).texture("wood", this.modLoc("block/upholstered_stool/base/" + block.getBaseName()))).texture("wool", this.modLoc("block/upholstered_stool/colors/" + block.getColor()));
        } else {
            model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.modLoc("block/template_stool"))).texture("stool", this.modLoc("block/stool/" + this.getName(block)));
            rotatedModel = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_rotated", this.modLoc("block/template_stool_rotated"))).texture("stool", this.modLoc("block/stool/" + this.getName(block)));
        }
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> ModBlockStateProvider.lambda$stoolBlock$21((ModelFile)rotatedModel, (ModelFile)model, arg_0), new Property[]{BlockStateProperties.f_61362_});
    }

    private static /* synthetic */ ConfiguredModel[] lambda$stoolBlock$21(ModelFile rotatedModel, ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ModBlockStateProperties.ROTATED) != false ? rotatedModel : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStatesAndModels$10(ModelFile modelOn, ModelFile model, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)ModBlockStateProperties.SWITCHED_ON) != false ? modelOn : model).build();
    }
}

