/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block.properties;

import javax.annotation.Nonnull;
import net.minecraft.util.StringRepresentable;
import net.valhelsia.valhelsia_furniture.common.block.properties.CurtainPart;

public enum OpenCurtainPart implements StringRepresentable,
CurtainPart
{
    SINGLE("single", CurtainPart.ModelType.CURTAIN, "curtain_open", "curtain_open"),
    SINGLE_TOP("single_top", CurtainPart.ModelType.CURTAIN, "top_middle_open", "top_middle_open"),
    SINGLE_BOTTOM("single_bottom", CurtainPart.ModelType.CURTAIN_FULL, "down_middle_open", "down_middle_open"),
    SINGLE_MIDDLE("single_middle", CurtainPart.ModelType.CURTAIN_FULL, "middle_open", "middle_open"),
    TOP("top", CurtainPart.ModelType.CURTAIN_BRACKET, "middle", "middle"),
    MIDDLE("middle", CurtainPart.ModelType.CURTAIN_FULL, "middle", "middle"),
    LEFT("left", CurtainPart.ModelType.CURTAIN, "down_side_open", "down_side_open"),
    RIGHT("right", CurtainPart.ModelType.CURTAIN_MIRRORED, "down_side_open", "down_side_open"),
    LEFT_SIDE_TOP("left_side_top", CurtainPart.ModelType.CURTAIN, "top_side_open", "top_side_open"),
    LEFT_SIDE_MIDDLE("left_side_middle", CurtainPart.ModelType.CURTAIN_FULL, "middle_side_open", "middle_side_open"),
    LEFT_SIDE_BOTTOM("left_side_bottom", CurtainPart.ModelType.CURTAIN_FULL, "down_side_open", "down_side_open"),
    RIGHT_SIDE_TOP("right_side_top", CurtainPart.ModelType.CURTAIN_MIRRORED, "top_side_open", "top_side_open"),
    RIGHT_SIDE_MIDDLE("right_side_middle", CurtainPart.ModelType.CURTAIN_FULL_MIRRORED, "middle_side_open", "middle_side_open"),
    RIGHT_SIDE_BOTTOM("right_side_bottom", CurtainPart.ModelType.CURTAIN_FULL_MIRRORED, "down_side_open", "down_side_open");

    private final String name;
    private final CurtainPart.ModelType modelType;
    private final String topTexture;
    private final String bottomTexture;

    private OpenCurtainPart(String name, CurtainPart.ModelType modelType, String topTexture, String bottomTexture) {
        this.name = name;
        this.modelType = modelType;
        this.topTexture = topTexture;
        this.bottomTexture = bottomTexture;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }

    @Override
    public String getModelName() {
        return "_" + this.name;
    }

    @Override
    public String getTopTexture() {
        return this.topTexture;
    }

    @Override
    public String getBottomTexture() {
        return this.bottomTexture;
    }

    @Override
    public CurtainPart.ModelType getModelType() {
        return this.modelType;
    }

    @Override
    public boolean isSingleRow() {
        return this.name.contains("single");
    }

    @Override
    public boolean isTopOrSingle() {
        return this.name.contains("top") || this == SINGLE;
    }

    public boolean isMiddle() {
        return this.name.contains("middle");
    }

    @Override
    public boolean isSingle() {
        return this == SINGLE;
    }

    @Override
    public boolean isBottomOrSingle() {
        return this.name.contains("bottom") || this == SINGLE;
    }

    public static OpenCurtainPart getTypeForConnections(boolean connectUp, boolean connectDown) {
        if (connectUp && connectDown) {
            return SINGLE_MIDDLE;
        }
        if (connectUp) {
            return SINGLE_BOTTOM;
        }
        if (connectDown) {
            return SINGLE_TOP;
        }
        return SINGLE;
    }
}

