/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_furniture.common.block;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;
import net.valhelsia.valhelsia_furniture.common.block.DeskBlock;
import net.valhelsia.valhelsia_furniture.common.block.entity.DeskDrawerBlockEntity;

public class DeskDrawerBlock
extends DeskBlock
implements EntityBlock {
    private static final VoxelShape DRAWER_SHAPE = Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0);
    private static final Map<Direction, VoxelShape> LEFT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)1.0, (double)1.0, (double)12.0, (double)4.0));
    private static final Map<Direction, VoxelShape> RIGHT_CONNECT_SHAPES = VoxelShapeHelper.getHorizontalRotatedShapes((VoxelShape)Block.m_49796_((double)15.0, (double)4.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0));
    private final Map<BlockState, VoxelShape> shapesCache = this.m_152458_(this::calculateShape);

    public DeskDrawerBlock(TagKey<Block> tag, BlockBehaviour.Properties properties) {
        super(tag, properties);
    }

    private VoxelShape calculateShape(BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean left = (Boolean)state.m_61143_((Property)LEFT);
        boolean right = (Boolean)state.m_61143_((Property)RIGHT);
        VoxelShape shape = Shapes.m_83110_((VoxelShape)SHAPE, (VoxelShape)DRAWER_SHAPE);
        if (left && right) {
            shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{LEFT_CONNECT_SHAPES.get(facing.m_122424_()), RIGHT_CONNECT_SHAPES.get(facing.m_122424_())});
        } else if (left) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)LEFT_CONNECT_SHAPES.get(facing.m_122424_()));
        } else if (right) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RIGHT_CONNECT_SHAPES.get(facing.m_122424_()));
        }
        return shape;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new DeskDrawerBlockEntity(pos, state);
    }

    @Override
    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.shapesCache.get(state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DeskDrawerBlockEntity) {
            DeskDrawerBlockEntity blockEntity2 = (DeskDrawerBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)blockEntity2);
            player.m_36220_(Stats.f_12971_);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                Containers.m_19002_((Level)level, (BlockPos)pos, (Container)container);
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

