/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsManager;

public record UpdateCosmeticsPacket(UUID uuid, CompoundTag activeCosmetics) {
    public static void encode(UpdateCosmeticsPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130077_(packet.uuid);
        buffer.m_130079_(packet.activeCosmetics);
    }

    public static UpdateCosmeticsPacket decode(FriendlyByteBuf buffer) {
        return new UpdateCosmeticsPacket(buffer.m_130259_(), buffer.m_130260_());
    }

    public static void consume(UpdateCosmeticsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
                cosmeticsManager.getActiveCosmetics(packet.uuid, true).set(packet.activeCosmetics);
                cosmeticsManager.loadCosmeticsFor(packet.uuid);
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

