/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights.mixin.lightsource;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.thinkingstudio.ryoamiclights.DynamicLightSource;
import org.thinkingstudio.ryoamiclights.DynamicLightsMode;
import org.thinkingstudio.ryoamiclights.RyoamicLights;
import org.thinkingstudio.ryoamiclights.api.DynamicLightHandlers;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected BlockPos f_58858_;
    @Shadow
    @Nullable
    protected Level f_58857_;
    @Shadow
    protected boolean f_58859_;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet ryoamiclights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double ryoamicLights$getDynamicLightX() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightY() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    @Override
    public double ryoamicLights$getDynamicLightZ() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    @Override
    public Level ryoamicLights$getDynamicLightWorld() {
        return this.f_58857_;
    }

    @Inject(method={"markRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.ryoamicLights$setDynamicLightEnabled(false);
    }

    @Override
    public void ryoamicLights$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void ryoamicLights$dynamicLightTick() {
        if (this.f_58857_ == null || !this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.f_58859_) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((BlockEntity)this);
            RyoamicLights.updateTracking(this);
            if (!this.ryoamicLights$isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int ryoamicLights$getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean ryoamicLights$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = RyoamicLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean ryoamiclights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.ryoamicLights$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.ryoamicLights$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.ryoamiclights$trackedLitChunkPos.isEmpty()) {
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(Mth.m_14042_((int)this.f_58858_.m_123341_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123342_(), (int)16), Mth.m_14042_((int)this.f_58858_.m_123343_(), (int)16));
                RyoamicLights.updateTrackedChunks((BlockPos)chunkPos, null, this.ryoamiclights$trackedLitChunkPos);
                Direction directionX = (this.f_58858_.m_123341_() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.f_58858_.m_123342_() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.f_58858_.m_123343_() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.m_122173_(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.m_122173_(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.m_122173_(directionX.m_122424_());
                    } else {
                        chunkPos.m_122173_(directionZ.m_122424_());
                        chunkPos.m_122173_(directionY);
                    }
                    RyoamicLights.updateTrackedChunks((BlockPos)chunkPos, null, this.ryoamiclights$trackedLitChunkPos);
                }
            }
            this.ryoamiclights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void ryoamiclights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (this.f_58857_ == Minecraft.m_91087_().f_91073_) {
            LongIterator longIterator = this.ryoamiclights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                RyoamicLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

