/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.ryoamiclights;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.thinkingstudio.obsidianui.SpruceTexts;
import org.thinkingstudio.obsidianui.util.Nameable;

public enum DynamicLightsMode implements Nameable
{
    OFF(0, ChatFormatting.RED, SpruceTexts.OPTIONS_OFF),
    FASTEST(500, ChatFormatting.GOLD, SpruceTexts.OPTIONS_GENERIC_FASTEST),
    FAST(250, ChatFormatting.YELLOW, SpruceTexts.OPTIONS_GENERIC_FAST),
    FANCY(0, ChatFormatting.GREEN, SpruceTexts.OPTIONS_GENERIC_FANCY);

    private final int delay;
    private final Component translatedText;

    private DynamicLightsMode(@NotNull int delay, ChatFormatting formatting, Component translatedText) {
        this.delay = delay;
        this.translatedText = translatedText.m_6881_().m_130940_(formatting);
    }

    public boolean isEnabled() {
        return this != OFF;
    }

    public boolean hasDelay() {
        return this.delay != 0;
    }

    public int getDelay() {
        return this.delay;
    }

    public DynamicLightsMode next() {
        DynamicLightsMode[] v = DynamicLightsMode.values();
        if (v.length == this.ordinal() + 1) {
            return v[0];
        }
        return v[this.ordinal() + 1];
    }

    @NotNull
    public Component getTranslatedText() {
        return this.translatedText;
    }

    @NotNull
    public String getName() {
        return this.name().toLowerCase();
    }

    @NotNull
    public static Optional<DynamicLightsMode> byId(@NotNull String id) {
        return Arrays.stream(DynamicLightsMode.values()).filter(mode -> mode.getName().equalsIgnoreCase(id)).findFirst();
    }
}

