/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;

public class Config {
    private static final Path CONFIG_PATH = EuphoriaPatcher.configDirectory.resolve("euphoria_patcher.properties");
    private static final Properties properties = new Properties();

    public static void createConfig() {
        try {
            Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            try (FileWriter writer = new FileWriter(String.valueOf(CONFIG_PATH), true);){
                writer.write("# This file stores configuration options for the Euphoria Patcher mod\n");
                writer.write("# Thank you for using Euphoria Patches - SpacEagle17\n");
            }
            EuphoriaPatcher.log(0, "Successfully created config file");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error creating config file: " + e.getMessage());
        }
    }

    public static void writeConfig(String option, String value, String description) {
        block17: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    Config.createConfig();
                }
                Config.loadProperties();
                if (properties.containsKey(option)) break block17;
                try (FileWriter writer = new FileWriter(String.valueOf(CONFIG_PATH), true);){
                    writer.write("\n");
                    if (description != null) {
                        String[] lines;
                        for (String line : lines = description.split("\n")) {
                            writer.write("# " + line + "\n");
                        }
                    }
                    writer.write(option + "=" + value + "\n");
                    EuphoriaPatcher.log(0, "Successfully wrote to config file: " + option + "=" + value);
                }
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Error writing to config file: " + e.getMessage());
            }
        }
    }

    public static String readWriteConfig(String optionName, String defaultValue, String description) {
        Config.writeConfig(optionName, defaultValue, description);
        return properties.getProperty(optionName, defaultValue);
    }

    private static void loadProperties() {
        try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
            properties.load(in);
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error loading properties: " + e.getMessage());
        }
    }
}

