/*
 * Decompiled with CFR 0.152.
 */
package cech12.unlitcampfire.mixin;

import cech12.unlitcampfire.ModTags;
import cech12.unlitcampfire.config.ServerConfig;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockEntityMixin;
import cech12.unlitcampfire.mixinaccess.ICampfireBlockMixin;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CampfireBlock.class})
public abstract class CampfireBlockMixin
extends BaseEntityBlock
implements ICampfireBlockMixin {
    protected CampfireBlockMixin(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Override
    public int getMaxLitTime(BlockState state) {
        return state.m_60734_() == Blocks.f_50684_ ? (Integer)ServerConfig.SOUL_CAMPFIRE_LIT_TIME.get() : (Integer)ServerConfig.CAMPFIRE_LIT_TIME.get();
    }

    @Override
    public boolean burnsInfinite(BlockState state) {
        return (Boolean)state.m_61143_((Property)ICampfireBlockMixin.INFINITE) != false || this.getMaxLitTime(state) < 1;
    }

    private boolean canAddBurnables(BlockState state) {
        return (Boolean)state.m_61143_((Property)ICampfireBlockMixin.INFINITE) == false && (state.m_60734_() == Blocks.f_50684_ ? (Boolean)ServerConfig.SOUL_CAMPFIRE_ADDING_BURNABLES.get() : (Boolean)ServerConfig.CAMPFIRE_ADDING_BURNABLES.get()) != false;
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>*"})
    protected void initProxy(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties, CallbackInfo info) {
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="RETURN")}, method={"getStateForPlacement"}, cancellable=true)
    protected void getStateForPlacementProxy(BlockPlaceContext context, CallbackInfoReturnable<BlockState> cir) {
        if (cir.getReturnValue() != null) {
            cir.setReturnValue((Object)((BlockState)((BlockState)cir.getReturnValue()).m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))));
            cir.setReturnValue((Object)((BlockState)((BlockState)cir.getReturnValue()).m_61124_((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(false))));
            cir.cancel();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"use"}, cancellable=true)
    protected void useProxy(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (((InteractionResult)cir.getReturnValue()).m_19077_()) {
            return;
        }
        if (!((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue() || this.burnsInfinite(state)) {
            return;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_204117_(ModTags.Items.MAKES_CAMPFIRE_INFINITE)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ICampfireBlockMixin.INFINITE, (Comparable)Boolean.valueOf(true)), 3);
            cir.setReturnValue((Object)InteractionResult.m_19078_((!level.f_46443_ ? 1 : 0) != 0));
            cir.cancel();
        } else {
            ICampfireBlockEntityMixin campfireBlockEntityMixin;
            if (!this.canAddBurnables(state)) {
                return;
            }
            int burnTime = ForgeHooks.getBurnTime((ItemStack)stack, null);
            if (burnTime < 1) {
                return;
            }
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof ICampfireBlockEntityMixin && (campfireBlockEntityMixin = (ICampfireBlockEntityMixin)blockentity).addLitTime(burnTime)) {
                cir.setReturnValue((Object)InteractionResult.m_19078_((!level.f_46443_ ? 1 : 0) != 0));
                cir.cancel();
            }
        }
        if (!player.m_150110_().f_35937_ && ((InteractionResult)cir.getReturnValue()).m_19077_()) {
            ItemStack remainingStack = stack.getCraftingRemainingItem();
            if (remainingStack != ItemStack.f_41583_) {
                player.m_21008_(hand, remainingStack);
            } else {
                stack.m_41774_(1);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"createBlockStateDefinition"})
    protected void createBlockStateDefinitionProxy(StateDefinition.Builder<Block, BlockState> stateBuilder, CallbackInfo info) {
        stateBuilder.m_61104_(new Property[]{INFINITE});
    }

    @Intrinsic(displace=true)
    public void id$animateTick(@Nonnull BlockState stateIn, Level worldIn, BlockPos pos, @Nonnull RandomSource rand) {
        int particleFactor = 1;
        if (worldIn.m_46758_(pos.m_7494_())) {
            particleFactor = worldIn.m_8055_(pos).m_60734_() == Blocks.f_50684_ ? ((Integer)ServerConfig.SOUL_CAMPFIRE_RAIN_PARTICLE_FACTOR.get()).intValue() : ((Integer)ServerConfig.CAMPFIRE_RAIN_PARTICLE_FACTOR.get()).intValue();
        }
        for (int i = 0; i < particleFactor; ++i) {
            this.m_214162_(stateIn, worldIn, pos, rand);
        }
    }
}

