/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.platform;

import io.github.flemmli97.tenshilib.platform.EventCalls;
import io.github.flemmli97.tenshilib.platform.InitUtil;
import io.github.flemmli97.tenshilib.platform.registry.CustomRegistryEntry;
import io.github.flemmli97.tenshilib.platform.registry.PlatformRegistry;
import io.github.flemmli97.tenshilib.platform.registry.SimpleRegistryWrapper;
import io.github.flemmli97.tenshilib.platform.registry.VanillaRegistryHandler;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;

public abstract class PlatformUtils {
    public static final PlatformUtils INSTANCE = InitUtil.getPlatformInstance(PlatformUtils.class, "io.github.flemmli97.tenshilib.fabric.platform.PlatformUtilsImpl", "io.github.flemmli97.tenshilib.forge.platform.PlatformUtilsImpl");

    public abstract SimpleRegistryWrapper<Item> items();

    public abstract SimpleRegistryWrapper<Block> blocks();

    public abstract SimpleRegistryWrapper<BlockEntityType<?>> blocksEntities();

    public abstract SimpleRegistryWrapper<EntityType<?>> entities();

    public abstract SimpleRegistryWrapper<Fluid> fluids();

    public abstract SimpleRegistryWrapper<MobEffect> effects();

    public abstract SimpleRegistryWrapper<Enchantment> enchantments();

    public abstract SimpleRegistryWrapper<MenuType<?>> containers();

    public abstract SimpleRegistryWrapper<Attribute> attributes();

    public abstract SimpleRegistryWrapper<ParticleType<?>> particles();

    public abstract <T> SimpleRegistryWrapper<T> registry(ResourceKey<? extends Registry<T>> var1);

    public <T> ResourceLocation idOf(T t, ResourceKey<? extends Registry<T>> key) {
        return this.registryFrom(key).m_7981_(t);
    }

    public <T> PlatformRegistry<T> of(ResourceKey<? extends Registry<T>> key, String modid) {
        return new VanillaRegistryHandler(key, modid);
    }

    public abstract <T extends CustomRegistryEntry<T>> PlatformRegistry<T> customRegistry(ResourceKey<? extends Registry<T>> var1, String var2);

    public abstract <T extends CustomRegistryEntry<T>> PlatformRegistry<T> customRegistry(ResourceKey<? extends Registry<T>> var1, ResourceLocation var2, boolean var3, boolean var4);

    protected <T> Registry<T> registryFrom(ResourceKey<? extends Registry<T>> key) {
        Registry reg = (Registry)Registry.f_122897_.m_7745_(key.m_135782_());
        if (reg == null) {
            throw new NullPointerException("Failed to get a corresponding registry for " + key);
        }
        return reg;
    }

    public abstract CreativeModeTab tab(ResourceLocation var1, Supplier<ItemStack> var2);

    public abstract <T extends BlockEntity> BlockEntityType<T> blockEntityType(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    public TagKey<Item> itemTag(ResourceLocation res) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)res);
    }

    public TagKey<Block> blockTag(ResourceLocation res) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)res);
    }

    public TagKey<EntityType<?>> entityTag(ResourceLocation res) {
        return TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)res);
    }

    public <T> TagKey<T> tag(ResourceKey<Registry<T>> key, ResourceLocation res) {
        return TagKey.m_203882_(key, (ResourceLocation)res);
    }

    public abstract void registerAOEEventHandler(EventCalls.Func3<Player, ItemStack, List<Entity>, Boolean> var1);
}

