/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.patreon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.flemmli97.tenshilib.TenshiLib;
import io.github.flemmli97.tenshilib.patreon.RenderLocation;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;

public class PatreonDataManager {
    private static final String URL = "https://gist.githubusercontent.com/Flemmli97/81636b52dc2f031ee8319b145c6808a5/raw/c67fcb69d39a55d0b0b24983be37be49f329136b/patreon.json";
    private static Map<String, PatreonPlayerInfo> PLAYERS;
    private static boolean READING;
    private static final Gson GSON;

    public static void init() {
        if (PLAYERS == null) {
            new Thread(() -> {
                JsonArray arr = null;
                try {
                    URLConnection conn = new URL(URL).openConnection();
                    InputStreamReader reader = new InputStreamReader(conn.getInputStream());
                    arr = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    TenshiLib.logger.error("Couldn't get patreon file");
                    e.printStackTrace();
                }
                if (arr != null) {
                    PLAYERS = new HashMap<String, PatreonPlayerInfo>();
                    arr.forEach(el -> {
                        if (el.isJsonObject()) {
                            JsonObject o = el.getAsJsonObject();
                            RenderLocation loc = null;
                            try {
                                loc = RenderLocation.valueOf(GsonHelper.m_13906_((JsonObject)o, (String)"defaultRenderLocation"));
                            }
                            catch (JsonSyntaxException | IllegalArgumentException throwable) {
                                // empty catch block
                            }
                            PatreonPlayerInfo info = new PatreonPlayerInfo(GsonHelper.m_13824_((JsonObject)o, (String)"tier", (int)1), GsonHelper.m_13851_((JsonObject)o, (String)"defaultEffect", (String)""), loc, GsonHelper.m_13824_((JsonObject)o, (String)"defaultColor", (int)-1));
                            PLAYERS.put(GsonHelper.m_13906_((JsonObject)o, (String)"uuid"), info);
                        }
                    });
                }
                READING = false;
            }).start();
        }
    }

    public static PatreonPlayerInfo get(String uuid) {
        if (READING || PLAYERS == null) {
            return PatreonPlayerInfo.NON_PATREON;
        }
        return PLAYERS.getOrDefault(uuid, PatreonPlayerInfo.NON_PATREON);
    }

    static {
        READING = true;
        GSON = new GsonBuilder().create();
    }

    public record PatreonPlayerInfo(int tier, String defaultEffect, RenderLocation defaultRenderLocation, int color) {
        static PatreonPlayerInfo NON_PATREON = new PatreonPlayerInfo(0, "", RenderLocation.HAT, -1);
    }
}

