/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.tenshilib.api.entity;

import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class AnimationHandler<T extends Entity> {
    private AnimatedAction currentAnim;
    private final T entity;
    private final AnimatedAction[] anims;
    private Function<AnimatedAction, Boolean> onAnimationSetFunc;
    private Consumer<AnimatedAction> onAnimationSetCons;
    private Consumer<AnimatedAction> onRunAnimation;

    public AnimationHandler(T entity, AnimatedAction[] anims) {
        this.entity = entity;
        Objects.requireNonNull(anims);
        this.anims = anims;
    }

    public AnimationHandler<T> setAnimationChangeFunc(Function<AnimatedAction, Boolean> onAnimationSet) {
        this.onAnimationSetFunc = onAnimationSet;
        return this;
    }

    public AnimationHandler<T> setAnimationChangeCons(Consumer<AnimatedAction> onAnimationSetCons) {
        this.onAnimationSetCons = onAnimationSetCons;
        return this;
    }

    public AnimationHandler<T> addActionHandle(Consumer<AnimatedAction> handleAction) {
        this.onRunAnimation = handleAction;
        return this;
    }

    @Nullable
    public AnimatedAction getAnimation() {
        return this.currentAnim;
    }

    public void runIfAnimation(String id, Consumer<AnimatedAction> anim) {
        if (this.isCurrentAnim(id)) {
            anim.accept(this.getAnimation());
        }
    }

    public void runIfNotNull(Consumer<AnimatedAction> cons) {
        if (this.currentAnim != null) {
            cons.accept(this.currentAnim);
        }
    }

    public boolean hasAnimation() {
        return this.currentAnim != null;
    }

    public void setAnimation(AnimatedAction anim) {
        if (this.onAnimationSetCons != null) {
            this.onAnimationSetCons.accept(anim);
        }
        if (this.onAnimationSetFunc != null && this.onAnimationSetFunc.apply(anim).booleanValue()) {
            return;
        }
        AnimatedAction animatedAction = this.currentAnim = anim == null ? null : anim.create();
        if (!((Entity)this.entity).f_19853_.f_46443_) {
            EventCalls.INSTANCE.sendEntityAnimationPacket(this.entity);
        }
    }

    public AnimatedAction[] getAnimations() {
        return this.anims;
    }

    public boolean isCurrentAnim(String id) {
        return this.hasAnimation() && this.getAnimation().getID().equals(id);
    }

    public boolean isCurrentAnim(String ... ids) {
        if (!this.hasAnimation()) {
            return false;
        }
        for (String id : ids) {
            if (!this.getAnimation().getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        if (this.hasAnimation()) {
            if (this.getAnimation().tick()) {
                this.setAnimation(null);
            } else if (this.onRunAnimation != null) {
                this.onRunAnimation.accept(this.getAnimation());
            }
        }
    }
}

