/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.tile_entities;

import andrews.table_top_craft.registry.TTCBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TicTacToeBlockEntity
extends BlockEntity {
    private String ticTacToeGame;
    private int[] frames;
    private String circleColor;
    private String crossColor;

    public TicTacToeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TTCBlockEntities.TIC_TAC_TOE.get(), pos, state);
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = new CompoundTag();
        this.saveToNBT(compound);
        return compound;
    }

    public void handleUpdateTag(CompoundTag compound) {
        this.m_142466_(compound);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.saveToNBT(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.loadFromNBT(compound);
        for (int i = 0; i < 9; ++i) {
            char charAtTile = this.getTicTacToeCharAt(i);
            if (charAtTile == '-') {
                if (this.getTicTacToeFrame(i) == 0 || this.getTicTacToeFrame(i) == -1) continue;
                this.setTicTacToeFrameAt(-1, i);
                continue;
            }
            if (charAtTile != 'X' && charAtTile != 'O' || this.getTicTacToeFrame(i) != -1) continue;
            this.setTicTacToeFrameAt(0, i);
        }
    }

    private void saveToNBT(CompoundTag compound) {
        CompoundTag chessNBT = new CompoundTag();
        chessNBT.m_128359_("TicTacToeGame", this.getTicTacToeGame());
        if (this.circleColor != null) {
            chessNBT.m_128359_("CircleColor", this.getCircleColor());
        }
        if (this.crossColor != null) {
            chessNBT.m_128359_("CrossColor", this.getCrossColor());
        }
        compound.m_128365_("TicTacToeValues", (Tag)chessNBT);
    }

    private void loadFromNBT(CompoundTag compound) {
        CompoundTag chessNBT = compound.m_128469_("TicTacToeValues");
        if (chessNBT.m_128425_("TicTacToeGame", 8)) {
            this.ticTacToeGame = chessNBT.m_128461_("TicTacToeGame");
        }
        if (chessNBT.m_128425_("CircleColor", 8)) {
            this.circleColor = chessNBT.m_128461_("CircleColor");
        }
        if (chessNBT.m_128425_("CrossColor", 8)) {
            this.crossColor = chessNBT.m_128461_("CrossColor");
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TicTacToeBlockEntity blockEntity) {
        String game = blockEntity.getTicTacToeGame().replaceAll("/", "");
        for (int i = 0; i < 9; ++i) {
            if (game.charAt(i) == 'O' && blockEntity.getTicTacToeFrames()[i] >= 0 && blockEntity.getTicTacToeFrames()[i] < 15) {
                blockEntity.setTicTacToeFrameAt(blockEntity.getTicTacToeFrames()[i] + 1, i);
            }
            if (game.charAt(i) != 'X' || blockEntity.getTicTacToeFrames()[i] < 0 || blockEntity.getTicTacToeFrames()[i] >= 13) continue;
            blockEntity.setTicTacToeFrameAt(blockEntity.getTicTacToeFrames()[i] + 1, i);
        }
    }

    public String getTicTacToeGame() {
        return this.ticTacToeGame == null ? "---/---/---" : this.ticTacToeGame;
    }

    public char getTicTacToeCharAt(int index) {
        char[] gameChars = this.getTicTacToeGame().replaceAll("/", "").toCharArray();
        return gameChars[index];
    }

    public int[] getTicTacToeFrames() {
        int[] nArray;
        if (this.frames == null) {
            int[] nArray2 = new int[9];
            nArray2[0] = -1;
            nArray2[1] = -1;
            nArray2[2] = -1;
            nArray2[3] = -1;
            nArray2[4] = -1;
            nArray2[5] = -1;
            nArray2[6] = -1;
            nArray2[7] = -1;
            nArray = nArray2;
            nArray2[8] = -1;
        } else {
            nArray = this.frames;
        }
        return nArray;
    }

    public int getTicTacToeFrame(int index) {
        if (this.frames == null) {
            int c1 = this.getTicTacToeCharAt(0) == '-' ? -1 : 0;
            int c2 = this.getTicTacToeCharAt(1) == '-' ? -1 : 0;
            int c3 = this.getTicTacToeCharAt(2) == '-' ? -1 : 0;
            int c4 = this.getTicTacToeCharAt(3) == '-' ? -1 : 0;
            int c5 = this.getTicTacToeCharAt(4) == '-' ? -1 : 0;
            int c6 = this.getTicTacToeCharAt(5) == '-' ? -1 : 0;
            int c7 = this.getTicTacToeCharAt(6) == '-' ? -1 : 0;
            int c8 = this.getTicTacToeCharAt(7) == '-' ? -1 : 0;
            int c9 = this.getTicTacToeCharAt(8) == '-' ? -1 : 0;
            this.frames = new int[]{c1, c2, c3, c4, c5, c6, c7, c8, c9};
        }
        return this.frames[index];
    }

    public void setTicTacToeFrameAt(int value, int index) {
        if (this.frames == null) {
            this.frames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
        }
        this.frames[index] = value;
    }

    public void resetFrames() {
        this.frames = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
    }

    public void setTicTacToeGame(String game) {
        this.ticTacToeGame = game;
        this.m_6596_();
    }

    public String getCircleColor() {
        if (this.circleColor == null) {
            this.circleColor = "249/255/254";
        }
        return this.circleColor;
    }

    public String getCrossColor() {
        if (this.crossColor == null) {
            this.crossColor = "249/255/254";
        }
        return this.crossColor;
    }

    public void setCircleColor(String circleColor) {
        this.circleColor = circleColor;
        this.m_6596_();
    }

    public void setCrossColor(String crossColor) {
        this.crossColor = crossColor;
        this.m_6596_();
    }

    public boolean isGameOver(String game) {
        String[] rows = game.split("/");
        if (rows[0].equals("XXX") || rows[0].equals("OOO") || rows[1].equals("XXX") || rows[1].equals("OOO") || rows[2].equals("XXX") || rows[2].equals("OOO")) {
            return true;
        }
        if (rows[0].charAt(0) == 'X' && rows[1].charAt(0) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(0) == 'O' && rows[2].charAt(0) == 'O') {
            return true;
        }
        if (rows[0].charAt(1) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(1) == 'X' || rows[0].charAt(1) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(1) == 'O') {
            return true;
        }
        if (rows[0].charAt(2) == 'X' && rows[1].charAt(2) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(2) == 'O' && rows[2].charAt(2) == 'O') {
            return true;
        }
        if (rows[0].charAt(0) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(2) == 'X' || rows[0].charAt(0) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(2) == 'O') {
            return true;
        }
        return rows[0].charAt(2) == 'X' && rows[1].charAt(1) == 'X' && rows[2].charAt(0) == 'X' || rows[0].charAt(2) == 'O' && rows[1].charAt(1) == 'O' && rows[2].charAt(0) == 'O';
    }
}

