/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.screens.chess.buttons.pieces;

import andrews.table_top_craft.registry.TTCBlocks;
import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class ChessBoardPawnPromotionButton
extends Button {
    private static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("table_top_craft", "textures/gui/buttons/chess_pawn_promotion_buttons.png");
    private static final Component QUEEN_TOOLTIP = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.queen");
    private static final Component BISHOP_TOOLTIP = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.bishop");
    private static final Component KNIGHT_TOOLTIP = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.knight");
    private static final Component ROOK_TOOLTIP = Component.m_237115_((String)"tooltip.table_top_craft.chess_piece_figure.type.rook");
    private final ItemStack CHESS_PIECE_FIGURE = new ItemStack((ItemLike)TTCBlocks.CHESS_PIECE_FIGURE.get());
    private final ChessTileEntity blockEntity;
    private final PawnPromotionPieceType type;

    public ChessBoardPawnPromotionButton(ChessTileEntity blockEntity, int x, int y, boolean isWhite, PawnPromotionPieceType type) {
        super(x, y, 43, 43, (Component)Component.m_237113_((String)""), Button::m_5691_);
        this.blockEntity = blockEntity;
        this.type = type;
        ChessPieceFigureBlockEntity previewBlockEntity = new ChessPieceFigureBlockEntity(BlockPos.f_121853_, ((Block)TTCBlocks.CHESS_PIECE_FIGURE.get()).m_49966_());
        previewBlockEntity.setPieceSet(blockEntity.getPieceSet() + 1);
        previewBlockEntity.setPieceType(type.getPieceType());
        previewBlockEntity.setPieceColor(isWhite ? blockEntity.getWhitePiecesColor() : blockEntity.getBlackPiecesColor());
        previewBlockEntity.setRotateChessPieceFigure(false);
        previewBlockEntity.m_187476_(this.CHESS_PIECE_FIGURE);
    }

    public void m_5691_() {
        NetworkUtil.doPawnPromotion(this.blockEntity.m_58899_(), (byte)this.type.getPieceType());
        Minecraft.m_91087_().f_91074_.m_6915_();
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BUTTONS_TEXTURE);
        this.m_93228_(poseStack, this.f_93620_, this.f_93621_, this.f_93622_ || this.m_93696_() ? 43 : 0, 0, 43, 43);
        this.renderChessPiece(poseStack, this.CHESS_PIECE_FIGURE, this.f_93620_ + 21, this.f_93621_ + 21 - 3, 40);
        RenderSystem.m_69465_();
        if (this.m_198029_() && Minecraft.m_91087_().f_91080_ != null) {
            switch (this.type) {
                default: {
                    Minecraft.m_91087_().f_91080_.m_96602_(poseStack, QUEEN_TOOLTIP, mouseX, mouseY);
                    break;
                }
                case BISHOP: {
                    Minecraft.m_91087_().f_91080_.m_96602_(poseStack, BISHOP_TOOLTIP, mouseX, mouseY);
                    break;
                }
                case KNIGHT: {
                    Minecraft.m_91087_().f_91080_.m_96602_(poseStack, KNIGHT_TOOLTIP, mouseX, mouseY);
                    break;
                }
                case ROOK: {
                    Minecraft.m_91087_().f_91080_.m_96602_(poseStack, ROOK_TOOLTIP, mouseX, mouseY);
                }
            }
        }
        RenderSystem.m_69482_();
    }

    private void renderChessPiece(PoseStack poseStack, ItemStack itemStack, int pX, int pY, int size) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BakedModel itemBakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)pX, (double)pY, 100.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_((float)size, (float)size, (float)size);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        itemRenderer.m_115143_(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, itemBakedModel);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public static enum PawnPromotionPieceType {
        QUEEN(6),
        BISHOP(3),
        KNIGHT(4),
        ROOK(2);

        final int pieceType;

        private PawnPromotionPieceType(int pieceType) {
            this.pieceType = pieceType;
        }

        public int getPieceType() {
            return this.pieceType;
        }
    }
}

