/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerShowTileInfo {
    private final BlockPos pos;

    public MessageServerShowTileInfo(BlockPos pos) {
        this.pos = pos;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public static MessageServerShowTileInfo deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new MessageServerShowTileInfo(pos);
    }

    public static void handle(MessageServerShowTileInfo message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos chessPos = message.pos;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity blockEntity;
                if (level != null && (blockEntity = level.m_7702_(chessPos)) instanceof ChessTileEntity) {
                    ChessTileEntity chessTileEntity;
                    chessTileEntity.setShowTileInfo(!(chessTileEntity = (ChessTileEntity)blockEntity).getShouldShowTileInfo());
                    level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

