/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerSetColor {
    private final int colorType;
    private final BlockPos pos;
    private final String color;

    public MessageServerSetColor(int colorType, BlockPos pos, String color) {
        this.colorType = colorType;
        this.pos = pos;
        this.color = color;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.colorType);
        buf.m_130064_(this.pos);
        buf.m_130070_(this.color);
    }

    public static MessageServerSetColor deserialize(FriendlyByteBuf buf) {
        int colorType = buf.readInt();
        BlockPos pos = buf.m_130135_();
        String color = buf.m_130136_(Short.MAX_VALUE);
        return new MessageServerSetColor(colorType, pos, color);
    }

    public static void handle(MessageServerSetColor message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos chessPos = message.pos;
        String color = message.color;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                if (level != null) {
                    BlockEntity blockEntity = level.m_7702_(chessPos);
                    if (blockEntity instanceof ChessTileEntity) {
                        ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
                        switch (message.colorType) {
                            case 0: {
                                chessTileEntity.setTileInfoColor(color);
                                break;
                            }
                            case 1: {
                                chessTileEntity.setLegalMoveColor(color);
                                break;
                            }
                            case 2: {
                                chessTileEntity.setInvalidMoveColor(color);
                                break;
                            }
                            case 3: {
                                chessTileEntity.setAttackMoveColor(color);
                                break;
                            }
                            case 4: {
                                chessTileEntity.setPreviousMoveColor(color);
                                break;
                            }
                            case 5: {
                                chessTileEntity.setCastleMoveColor(color);
                            }
                        }
                        level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
                        chessTileEntity.m_6596_();
                    } else if (blockEntity instanceof ChessPieceFigureBlockEntity) {
                        ChessPieceFigureBlockEntity chessPieceFigureBlockEntity = (ChessPieceFigureBlockEntity)blockEntity;
                        chessPieceFigureBlockEntity.setPieceColor(color);
                        level.m_7260_(message.pos, level.m_8055_(chessPos), level.m_8055_(chessPos), 2);
                        chessPieceFigureBlockEntity.m_6596_();
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

