/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerOpenGUIWithServerPlayer {
    private final BlockPos pos;

    public MessageServerOpenGUIWithServerPlayer(BlockPos pos) {
        this.pos = pos;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    public static MessageServerOpenGUIWithServerPlayer deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        return new MessageServerOpenGUIWithServerPlayer(pos);
    }

    public static void handle(MessageServerOpenGUIWithServerPlayer message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        ServerLevel level = player.m_9236_();
        BlockPos pos = message.pos;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerOpenGUIWithServerPlayer.lambda$handle$0((Level)level, pos, player));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Level level, BlockPos pos, ServerPlayer player) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.m_7702_(pos)) instanceof ChessTileEntity) {
            ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
            ServerAdvancementManager serveradvancementmanager = player.m_20194_().m_129889_();
            Advancement standardAdvancement = serveradvancementmanager.m_136041_(new ResourceLocation("table_top_craft:standard_piece_collector"));
            Advancement classicAdvancement = serveradvancementmanager.m_136041_(new ResourceLocation("table_top_craft:classic_piece_collector"));
            Advancement pandorasCreaturesAdvancement = serveradvancementmanager.m_136041_(new ResourceLocation("table_top_craft:pandoras_creatures_piece_collector"));
            boolean isStandardSetUnlocked = standardAdvancement == null || player.m_8960_().m_135996_(standardAdvancement).m_8193_();
            boolean isClassicSetUnlocked = classicAdvancement == null || player.m_8960_().m_135996_(classicAdvancement).m_8193_();
            boolean isPandorasCreaturesSetUnlocked = pandorasCreaturesAdvancement == null || player.m_8960_().m_135996_(pandorasCreaturesAdvancement).m_8193_();
            NetworkUtil.openChessPieceSelectionFromServer(pos, isStandardSetUnlocked, isClassicSetUnlocked, isPandorasCreaturesSetUnlocked, player);
        }
    }
}

