/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.criteria.TTCCriteriaTriggers;
import andrews.table_top_craft.tile_entities.ConnectFourBlockEntity;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerDoConnectFourInteraction {
    private final BlockPos pos;
    private final byte column;

    public MessageServerDoConnectFourInteraction(BlockPos pos, byte column) {
        this.pos = pos;
        this.column = column;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.column);
    }

    public static MessageServerDoConnectFourInteraction deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte column = buf.readByte();
        return new MessageServerDoConnectFourInteraction(pos, column);
    }

    public static void handle(MessageServerDoConnectFourInteraction message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        byte column = message.column;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerLevel level;
                BlockEntity blockEntity;
                if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ConnectFourBlockEntity) {
                    ConnectFourBlockEntity connectFourBlockEntity = (ConnectFourBlockEntity)blockEntity;
                    connectFourBlockEntity.addPieceToColumn(column);
                    level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                    connectFourBlockEntity.m_6596_();
                    if (!level.m_5776_() && connectFourBlockEntity.hasFourInARow()) {
                        TTCCriteriaTriggers.MAKE_CONNECT_FOUR_VICTORY_MOVE.trigger(player);
                    }
                    NetworkUtil.setConnectFourAnimationForAllTracking((Level)level, pos, (byte)(connectFourBlockEntity.getTopPieceInColumn(column) + 6 * column));
                }
            });
            context.setPacketHandled(true);
        }
    }
}

