/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.criteria.TTCCriteriaTriggers;
import andrews.table_top_craft.game_logic.chess.board.moves.BaseMove;
import andrews.table_top_craft.game_logic.chess.board.moves.MoveFactory;
import andrews.table_top_craft.game_logic.chess.board.tiles.BaseChessTile;
import andrews.table_top_craft.game_logic.chess.pieces.BasePiece;
import andrews.table_top_craft.game_logic.chess.player.MoveTransition;
import andrews.table_top_craft.tile_entities.ChessTileEntity;
import andrews.table_top_craft.util.NetworkUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerDoChessBoardInteraction {
    private final BlockPos pos;
    private final byte tileCoordinate;

    public MessageServerDoChessBoardInteraction(BlockPos pos, byte tileCoordinate) {
        this.pos = pos;
        this.tileCoordinate = tileCoordinate;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.tileCoordinate);
    }

    public static MessageServerDoChessBoardInteraction deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte tileCoordinate = buf.readByte();
        return new MessageServerDoChessBoardInteraction(pos, tileCoordinate);
    }

    public static void handle(MessageServerDoChessBoardInteraction message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        byte tileCoordinate = message.tileCoordinate;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                ServerLevel level;
                BlockEntity blockEntity;
                if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ChessTileEntity) {
                    ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
                    if (chessTileEntity.getBoard() == null) {
                        return;
                    }
                    if (chessTileEntity.doingAnimationTimer > 0L && chessTileEntity.move != null && chessTileEntity.transition != null) {
                        chessTileEntity.setBoard(chessTileEntity.transition.getTransitionBoard());
                        chessTileEntity.getMoveLog().addMove(chessTileEntity.move);
                        if (chessTileEntity.move.isPawnPromotion()) {
                            chessTileEntity.setWaitingForPromotion(true);
                            chessTileEntity.setPromotionCoordinate((byte)chessTileEntity.move.getDestinationCoordinate());
                            List players = player.m_9236_().m_6907_();
                            for (ServerPlayer serverPlayer : players) {
                                if (!serverPlayer.m_20148_().equals(chessTileEntity.getPromotionPlayerUUID())) continue;
                                NetworkUtil.openChessPromotionFromServer(chessTileEntity.m_58899_(), chessTileEntity.move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                            }
                            chessTileEntity.setPromotionPlayerUUID(null);
                        }
                        if (chessTileEntity.getDisplayParticles() && !chessTileEntity.playedParticles && chessTileEntity.move.isAttack() && !chessTileEntity.move.isEnPassantMove()) {
                            NetworkUtil.playChesParticlesFromServer((Level)level, pos, (byte)chessTileEntity.move.getDestinationCoordinate(), chessTileEntity.move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                        }
                        chessTileEntity.doingAnimationTimer = 0L;
                        chessTileEntity.move = null;
                        chessTileEntity.transition = null;
                        chessTileEntity.playedParticles = false;
                        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                        chessTileEntity.m_6596_();
                    }
                    BaseChessTile chessTile = chessTileEntity.getBoard().getTile(tileCoordinate);
                    if (chessTileEntity.getSourceTile() == null) {
                        if (chessTile.isTileOccupied() && chessTile.getPiece().getPieceColor() == chessTileEntity.getBoard().getCurrentChessPlayer().getPieceColor()) {
                            chessTileEntity.setSourceTile(chessTile);
                            chessTileEntity.setHumanMovedPiece(chessTile.getPiece());
                            if (chessTileEntity.getHumanMovedPiece() == null) {
                                chessTileEntity.setSourceTile(null);
                            }
                            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                            chessTileEntity.m_6596_();
                        }
                    } else {
                        chessTileEntity.setDestinationTile(chessTile);
                        BaseMove move = MoveFactory.createMove(chessTileEntity.getBoard(), chessTileEntity.getSourceTile().getTileCoordinate(), chessTileEntity.getDestinationTile().getTileCoordinate());
                        MoveTransition transition = chessTileEntity.getBoard().getCurrentChessPlayer().makeMove(move);
                        if (transition.getMoveStatus().isDone()) {
                            if (move.isPawnPromotion()) {
                                chessTileEntity.setPromotionPlayerUUID(player.m_20148_());
                            }
                            if (chessTileEntity.getPlayPieceAnimations()) {
                                chessTileEntity.move = move;
                                chessTileEntity.transition = transition;
                                int animTime = 1000;
                                if (move.getMovedPiece().getPieceType().isKing() && !move.isCastlingMove()) {
                                    animTime = 750;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.PAWN) && Math.abs(move.getDestinationCoordinate() - move.getCurrentCoordinate()) <= 9) {
                                    animTime = 750;
                                }
                                if (move.isEnPassantMove()) {
                                    animTime = 1000;
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.ROOK)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.BISHOP)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                if (move.getMovedPiece().getPieceType().equals((Object)BasePiece.PieceType.QUEEN)) {
                                    if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) == 1 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) == 1) {
                                        animTime = 750;
                                    } else if (Math.abs(move.getCurrentCoordinate() % 8 - move.getDestinationCoordinate() % 8) > 3 || Math.abs(move.getCurrentCoordinate() / 8 - move.getDestinationCoordinate() / 8) > 3) {
                                        animTime = 1250;
                                    }
                                }
                                chessTileEntity.doingAnimationTimer = System.currentTimeMillis() + (long)animTime;
                                NetworkUtil.setChessAnimationForAllTracking((Level)level, pos, (byte)2, (byte)move.getCurrentCoordinate(), (byte)move.getDestinationCoordinate());
                            } else {
                                chessTileEntity.setBoard(transition.getTransitionBoard());
                                chessTileEntity.getMoveLog().addMove(move);
                                if (move.isPawnPromotion()) {
                                    chessTileEntity.setWaitingForPromotion(true);
                                    chessTileEntity.setPromotionCoordinate((byte)move.getDestinationCoordinate());
                                    List players = player.m_9236_().m_6907_();
                                    for (ServerPlayer serverPlayer : players) {
                                        if (!serverPlayer.m_20148_().equals(chessTileEntity.getPromotionPlayerUUID())) continue;
                                        NetworkUtil.openChessPromotionFromServer(chessTileEntity.m_58899_(), move.getMovedPiece().getPieceColor().isWhite(), serverPlayer);
                                    }
                                    chessTileEntity.setPromotionPlayerUUID(null);
                                }
                                if (chessTileEntity.getDisplayParticles() && move.isAttack() && !move.isEnPassantMove()) {
                                    NetworkUtil.playChesParticlesFromServer((Level)level, pos, (byte)move.getDestinationCoordinate(), move.getMovedPiece().getPieceColor().isBlack(), 0.0f, 0.0f, 0.0f);
                                }
                            }
                            if (!level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_CHESS_MOVE.trigger(player);
                            }
                            if (move.isEnPassantMove() && !level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_EN_PASSANT_MOVE.trigger(player);
                            }
                            if (chessTileEntity.getBoard().getCurrentChessPlayer().isInCheckMate() && !level.f_46443_) {
                                TTCCriteriaTriggers.MAKE_CHECK_MATE_MOVE.trigger(player);
                            }
                        }
                        chessTileEntity.setSourceTile(null);
                        chessTileEntity.setDestinationTile(null);
                        chessTileEntity.setHumanMovedPiece(null);
                        level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
                        chessTileEntity.m_6596_();
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

