/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerChessVisuals {
    private final BlockPos pos;
    private final byte type;

    public MessageServerChessVisuals(BlockPos pos, byte type) {
        this.pos = pos;
        this.type = type;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeByte((int)this.type);
    }

    public static MessageServerChessVisuals deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        byte type = buf.readByte();
        return new MessageServerChessVisuals(pos, type);
    }

    public static void handle(MessageServerChessVisuals message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        BlockPos pos = message.pos;
        byte type = message.type;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> MessageServerChessVisuals.lambda$handle$0((Player)player, pos, type));
            context.setPacketHandled(true);
        }
    }

    private static /* synthetic */ void lambda$handle$0(Player player, BlockPos pos, byte type) {
        Level level;
        BlockEntity blockEntity;
        if (player != null && (blockEntity = (level = player.m_9236_()).m_7702_(pos)) instanceof ChessTileEntity) {
            ChessTileEntity chessTileEntity = (ChessTileEntity)blockEntity;
            switch (type) {
                default: {
                    chessTileEntity.setPlayPieceAnimations(!chessTileEntity.getPlayPieceAnimations());
                    break;
                }
                case 1: {
                    chessTileEntity.setDisplayParticles(!chessTileEntity.getDisplayParticles());
                }
            }
            level.m_7260_(pos, level.m_8055_(pos), level.m_8055_(pos), 2);
            chessTileEntity.m_6596_();
        }
    }
}

