/*
 * Decompiled with CFR 0.152.
 */
package andrews.table_top_craft.network.server;

import andrews.table_top_craft.tile_entities.ChessPieceFigureBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageServerChangePieceScale {
    private final BlockPos pos;
    private final double value;

    public MessageServerChangePieceScale(BlockPos pos, double value) {
        this.pos = pos;
        this.value = value;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeDouble(this.value);
    }

    public static MessageServerChangePieceScale deserialize(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        double value = buf.readDouble();
        return new MessageServerChangePieceScale(pos, value);
    }

    public static void handle(MessageServerChangePieceScale message, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        ServerPlayer player = context.getSender();
        Level level = player.m_9236_();
        BlockPos blockPos = message.pos;
        double value = message.value;
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity blockEntity;
                if (level != null && (blockEntity = level.m_7702_(blockPos)) instanceof ChessPieceFigureBlockEntity) {
                    ChessPieceFigureBlockEntity chessPieceFigureBlockEntity = (ChessPieceFigureBlockEntity)blockEntity;
                    chessPieceFigureBlockEntity.setPieceScale(value);
                    level.m_7260_(message.pos, level.m_8055_(blockPos), level.m_8055_(blockPos), 2);
                    chessPieceFigureBlockEntity.m_6596_();
                }
            });
            context.setPacketHandled(true);
        }
    }
}

