/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CapturedMobCache {
    private static final LoadingCache<UUID, Entity> MOB_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, Entity>(){

        public Entity load(UUID key) {
            return null;
        }
    });
    private static UUID crystalID = UUID.randomUUID();
    private static boolean updateCrystal = false;

    public static void addMob(Entity e) {
        if (e != null) {
            MOB_CACHE.put((Object)e.m_20148_(), (Object)e);
        }
    }

    @Nullable
    public static Entity getOrCreateCachedMob(UUID id, CompoundTag tag) {
        ClientLevel world;
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)id);
        if (e == null && (world = Minecraft.m_91087_().f_91073_) != null) {
            CompoundTag mobData = tag.m_128469_("EntityData");
            e = MobContainer.createEntityFromNBT(mobData, id, (Level)world);
            CapturedMobCache.addMob(e);
        }
        return e;
    }

    public static void tickCrystal() {
        if (!updateCrystal) {
            return;
        }
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)crystalID);
        if (e instanceof EndCrystal) {
            EndCrystal c = (EndCrystal)e;
            ++c.f_31032_;
            if (e.f_19853_ != Minecraft.m_91087_().f_91073_) {
                crystalID = UUID.randomUUID();
            }
        }
        updateCrystal = false;
    }

    public static EndCrystal getEndCrystal(Level level) {
        updateCrystal = true;
        Entity e = (Entity)MOB_CACHE.getIfPresent((Object)crystalID);
        if (e instanceof EndCrystal) {
            EndCrystal c = (EndCrystal)e;
            return c;
        }
        EndCrystal entity = new EndCrystal(EntityType.f_20564_, level);
        entity.m_31056_(false);
        entity.m_20084_(crystalID);
        CapturedMobCache.addMob((Entity)entity);
        return entity;
    }

    public static void clear() {
        MOB_CACHE.invalidateAll();
    }
}

