/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleQuiverPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class QuiverArrowSelectGui
extends Gui {
    private static final ResourceLocation TEXTURE = Supplementaries.res("textures/gui/quiver_select.png");
    private static boolean usingItem;
    private static double lastCumulativeMouseDx;
    private static boolean usingKey;
    protected final ItemRenderer itemRenderer;
    protected final Minecraft minecraft;

    public static boolean isActive() {
        return usingItem || usingKey;
    }

    public static void setUsingItem(boolean on) {
        if (on != usingItem) {
            lastCumulativeMouseDx = 0.0;
        }
        usingItem = on;
    }

    public static boolean isUsingKey() {
        return usingKey;
    }

    public static void setUsingKeybind(boolean on) {
        if (on != usingItem) {
            lastCumulativeMouseDx = 0.0;
        }
        usingKey = on;
    }

    protected QuiverArrowSelectGui(Minecraft minecraft, ItemRenderer itemRenderer) {
        super(minecraft, itemRenderer);
        this.itemRenderer = itemRenderer;
        this.minecraft = minecraft;
    }

    public static void ohMouseMoved(double deltaX) {
        LocalPlayer player;
        int oldI;
        int slotsMoved;
        double scale = (Double)Minecraft.m_91087_().f_91066_.m_231964_().m_231551_() * 0.02;
        if ((slotsMoved = (int)((lastCumulativeMouseDx += deltaX) * scale) - (oldI = (int)(lastCumulativeMouseDx * scale))) != 0 && (player = Minecraft.m_91087_().f_91074_) != null) {
            ServerBoundCycleQuiverPacket.Slot s = QuiverArrowSelectGui.getQuiverSlot((Player)player);
            NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(slotsMoved, s));
        }
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(scrollDelta > 0.0 ? -1 : 1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
        return true;
    }

    public static boolean onKeyPressed(int key, int action, int modifiers) {
        if (action == 1) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            switch (key) {
                case 263: {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(-1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
                    return true;
                }
                case 262: {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(1, QuiverArrowSelectGui.getQuiverSlot((Player)player)));
                    return true;
                }
            }
            int number = key - 48;
            if (number >= 1 && number <= 9) {
                if (number <= CommonConfigs.Tools.QUIVER_SLOTS.get()) {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(number - 1, QuiverArrowSelectGui.getQuiverSlot((Player)player), true));
                }
                return true;
            }
        }
        return false;
    }

    private void renderSlot(int pX, int pY, Player pPlayer, ItemStack pStack, int seed) {
        if (!pStack.m_41619_()) {
            this.itemRenderer.m_174229_((LivingEntity)pPlayer, pStack, pX, pY, seed);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            this.itemRenderer.m_115169_(this.minecraft.f_91062_, pStack, pX, pY);
        }
    }

    public void renderQuiverContent(PoseStack poseStack, float partialTicks, int screenWidth, int screenHeight) {
        Player player;
        ItemStack quiver;
        Entity entity = this.minecraft.m_91288_();
        if (entity instanceof Player && (quiver = QuiverArrowSelectGui.getCurrentlyUsedQuiver(player = (Player)entity)).m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            poseStack.m_85836_();
            QuiverItem.Data data = QuiverItem.getQuiverData(quiver);
            int selected = data.getSelectedSlot();
            List<ItemStack> items = data.getContentView();
            int slots = items.size();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int centerX = screenWidth / 2;
            int z = this.m_93252_();
            this.m_93250_(-90);
            int uWidth = slots * 20 + 2;
            int px = uWidth / 2;
            int py = screenHeight / 2 - 40;
            this.m_93228_(poseStack, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), 0, 0, uWidth - 1, 22);
            this.m_93228_(poseStack, centerX + px - 1, py, 0, 0, 1, 22);
            this.m_93228_(poseStack, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
            this.m_93250_(z);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            int i1 = 1;
            for (int i = 0; i < slots; ++i) {
                int kx = centerX - px + 3 + i * 20;
                this.renderSlot(kx, py + 3, player, items.get(i), i1++);
            }
            RenderSystem.m_69461_();
            ItemStack selectedArrow = items.get(selected);
            if (!selectedArrow.m_41619_()) {
                this.drawHighlight(poseStack, screenWidth, py, selectedArrow);
            }
            poseStack.m_85849_();
            QuiverArrowSelectGui.setUsingItem(true);
            return;
        }
        QuiverArrowSelectGui.setUsingItem(false);
    }

    @NotNull
    private static ServerBoundCycleQuiverPacket.Slot getQuiverSlot(Player player) {
        return usingKey ? ServerBoundCycleQuiverPacket.Slot.INVENTORY : (player.m_7655_() == InteractionHand.MAIN_HAND ? ServerBoundCycleQuiverPacket.Slot.MAIN_HAND : ServerBoundCycleQuiverPacket.Slot.OFF_HAND);
    }

    private static ItemStack getCurrentlyUsedQuiver(Player player) {
        if (usingKey) {
            return ((IQuiverEntity)player).getQuiver();
        }
        return player.m_21211_();
    }

    protected abstract void drawHighlight(PoseStack var1, int var2, int var3, ItemStack var4);

    static {
        lastCumulativeMouseDx = 0.0;
        usingKey = false;
    }
}

